// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.AI.TextAnalytics.Legacy.Models;

namespace Azure.AI.TextAnalytics.Legacy
{
    internal partial class TasksState
    {
        internal static TasksState DeserializeTasksState(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            TasksStateTasks tasks = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tasks"u8))
                {
                    tasks = TasksStateTasks.DeserializeTasksStateTasks(property.Value);
                    continue;
                }
            }
            return new TasksState(tasks);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TasksState FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTasksState(document.RootElement);
        }
    }
}
