// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.AI.TextAnalytics.Legacy.Models;

namespace Azure.AI.TextAnalytics.Legacy
{
    /// <summary> The TaskState. </summary>
    internal partial class TaskState
    {
        /// <summary> Initializes a new instance of <see cref="TaskState"/>. </summary>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="status"></param>
        internal TaskState(DateTimeOffset lastUpdateDateTime, State status)
        {
            LastUpdateDateTime = lastUpdateDateTime;
            Status = status;
        }

        /// <summary> Initializes a new instance of <see cref="TaskState"/>. </summary>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="taskName"></param>
        /// <param name="status"></param>
        internal TaskState(DateTimeOffset lastUpdateDateTime, string taskName, State status)
        {
            LastUpdateDateTime = lastUpdateDateTime;
            TaskName = taskName;
            Status = status;
        }

        /// <summary> Gets the last update date time. </summary>
        public DateTimeOffset LastUpdateDateTime { get; }
        /// <summary> Gets the task name. </summary>
        public string TaskName { get; }
        /// <summary> Gets the status. </summary>
        public State Status { get; }
    }
}
