// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.TextAnalytics.Legacy.Models
{
    internal static partial class StateExtensions
    {
        public static string ToSerialString(this State value) => value switch
        {
            State.NotStarted => "notStarted",
            State.Running => "running",
            State.Succeeded => "succeeded",
            State.Failed => "failed",
            State.Rejected => "rejected",
            State.Cancelled => "cancelled",
            State.Cancelling => "cancelling",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown State value.")
        };

        public static State ToState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "notStarted")) return State.NotStarted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "running")) return State.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "succeeded")) return State.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "failed")) return State.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "rejected")) return State.Rejected;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "cancelled")) return State.Cancelled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "cancelling")) return State.Cancelling;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown State value.");
        }
    }
}
