// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.AI.TextAnalytics.Legacy
{
    internal partial class PiiTaskResult
    {
        internal static PiiTaskResult DeserializePiiTaskResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PiiResult results = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("results"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    results = PiiResult.DeserializePiiResult(property.Value);
                    continue;
                }
            }
            return new PiiTaskResult(results);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static PiiTaskResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePiiTaskResult(document.RootElement);
        }
    }
}
