// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.TextAnalytics.Legacy.Models
{
    /// <summary> The PiiTaskParametersDomain. </summary>
    internal readonly partial struct PiiTaskParametersDomain : IEquatable<PiiTaskParametersDomain>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PiiTaskParametersDomain"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PiiTaskParametersDomain(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PhiValue = "phi";
        private const string NoneValue = "none";

        /// <summary> phi. </summary>
        public static PiiTaskParametersDomain Phi { get; } = new PiiTaskParametersDomain(PhiValue);
        /// <summary> none. </summary>
        public static PiiTaskParametersDomain None { get; } = new PiiTaskParametersDomain(NoneValue);
        /// <summary> Determines if two <see cref="PiiTaskParametersDomain"/> values are the same. </summary>
        public static bool operator ==(PiiTaskParametersDomain left, PiiTaskParametersDomain right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PiiTaskParametersDomain"/> values are not the same. </summary>
        public static bool operator !=(PiiTaskParametersDomain left, PiiTaskParametersDomain right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PiiTaskParametersDomain"/>. </summary>
        public static implicit operator PiiTaskParametersDomain(string value) => new PiiTaskParametersDomain(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PiiTaskParametersDomain other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PiiTaskParametersDomain other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
