// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.AI.TextAnalytics.Legacy.Models;

namespace Azure.AI.TextAnalytics.Legacy
{
    /// <summary> The PiiTaskParameters. </summary>
    internal partial class PiiTaskParameters
    {
        /// <summary> Initializes a new instance of <see cref="PiiTaskParameters"/>. </summary>
        public PiiTaskParameters()
        {
            PiiCategories = new ChangeTrackingList<PiiEntityLegacyCategory>();
        }

        /// <summary> Initializes a new instance of <see cref="PiiTaskParameters"/>. </summary>
        /// <param name="domain"></param>
        /// <param name="modelVersion"></param>
        /// <param name="loggingOptOut"></param>
        /// <param name="piiCategories"> (Optional) describes the PII categories to return. </param>
        /// <param name="stringIndexType"></param>
        internal PiiTaskParameters(PiiTaskParametersDomain? domain, string modelVersion, bool? loggingOptOut, IList<PiiEntityLegacyCategory> piiCategories, StringIndexType? stringIndexType)
        {
            Domain = domain;
            ModelVersion = modelVersion;
            LoggingOptOut = loggingOptOut;
            PiiCategories = piiCategories;
            StringIndexType = stringIndexType;
        }

        /// <summary> Gets or sets the domain. </summary>
        public PiiTaskParametersDomain? Domain { get; set; }
        /// <summary> Gets or sets the model version. </summary>
        public string ModelVersion { get; set; }
        /// <summary> Gets or sets the logging opt out. </summary>
        public bool? LoggingOptOut { get; set; }
        /// <summary> Gets or sets the string index type. </summary>
        public StringIndexType? StringIndexType { get; set; }
    }
}
