// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.TextAnalytics.Legacy.Models
{
    /// <summary> The PiiCategory. </summary>
    internal readonly partial struct PiiEntityLegacyCategory : IEquatable<PiiEntityLegacyCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PiiEntityLegacyCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PiiEntityLegacyCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ABARoutingNumberValue = "ABARoutingNumber";
        private const string ARNationalIdentityNumberValue = "ARNationalIdentityNumber";
        private const string AUBankAccountNumberValue = "AUBankAccountNumber";
        private const string AUDriversLicenseNumberValue = "AUDriversLicenseNumber";
        private const string AUMedicalAccountNumberValue = "AUMedicalAccountNumber";
        private const string AUPassportNumberValue = "AUPassportNumber";
        private const string AUTaxFileNumberValue = "AUTaxFileNumber";
        private const string AUBusinessNumberValue = "AUBusinessNumber";
        private const string AUCompanyNumberValue = "AUCompanyNumber";
        private const string ATIdentityCardValue = "ATIdentityCard";
        private const string ATTaxIdentificationNumberValue = "ATTaxIdentificationNumber";
        private const string ATValueAddedTaxNumberValue = "ATValueAddedTaxNumber";
        private const string AzureDocumentDBAuthKeyValue = "AzureDocumentDBAuthKey";
        private const string AzureIaasDatabaseConnectionAndSQLStringValue = "AzureIAASDatabaseConnectionAndSQLString";
        private const string AzureIoTConnectionStringValue = "AzureIoTConnectionString";
        private const string AzurePublishSettingPasswordValue = "AzurePublishSettingPassword";
        private const string AzureRedisCacheStringValue = "AzureRedisCacheString";
        private const string AzureSASValue = "AzureSAS";
        private const string AzureServiceBusStringValue = "AzureServiceBusString";
        private const string AzureStorageAccountKeyValue = "AzureStorageAccountKey";
        private const string AzureStorageAccountGenericValue = "AzureStorageAccountGeneric";
        private const string BENationalNumberValue = "BENationalNumber";
        private const string BENationalNumberV2Value = "BENationalNumberV2";
        private const string BEValueAddedTaxNumberValue = "BEValueAddedTaxNumber";
        private const string BrcpfNumberValue = "BRCPFNumber";
        private const string BRLegalEntityNumberValue = "BRLegalEntityNumber";
        private const string BRNationalIdrgValue = "BRNationalIDRG";
        private const string BGUniformCivilNumberValue = "BGUniformCivilNumber";
        private const string CABankAccountNumberValue = "CABankAccountNumber";
        private const string CADriversLicenseNumberValue = "CADriversLicenseNumber";
        private const string CAHealthServiceNumberValue = "CAHealthServiceNumber";
        private const string CAPassportNumberValue = "CAPassportNumber";
        private const string CAPersonalHealthIdentificationValue = "CAPersonalHealthIdentification";
        private const string CASocialInsuranceNumberValue = "CASocialInsuranceNumber";
        private const string CLIdentityCardNumberValue = "CLIdentityCardNumber";
        private const string CNResidentIdentityCardNumberValue = "CNResidentIdentityCardNumber";
        private const string CreditCardNumberValue = "CreditCardNumber";
        private const string HRIdentityCardNumberValue = "HRIdentityCardNumber";
        private const string HRNationalIDNumberValue = "HRNationalIDNumber";
        private const string HRPersonalIdentificationNumberValue = "HRPersonalIdentificationNumber";
        private const string HRPersonalIdentificationOIBNumberV2Value = "HRPersonalIdentificationOIBNumberV2";
        private const string CYIdentityCardValue = "CYIdentityCard";
        private const string CYTaxIdentificationNumberValue = "CYTaxIdentificationNumber";
        private const string CZPersonalIdentityNumberValue = "CZPersonalIdentityNumber";
        private const string CZPersonalIdentityV2Value = "CZPersonalIdentityV2";
        private const string DKPersonalIdentificationNumberValue = "DKPersonalIdentificationNumber";
        private const string DKPersonalIdentificationV2Value = "DKPersonalIdentificationV2";
        private const string DrugEnforcementAgencyNumberValue = "DrugEnforcementAgencyNumber";
        private const string EEPersonalIdentificationCodeValue = "EEPersonalIdentificationCode";
        private const string EUDebitCardNumberValue = "EUDebitCardNumber";
        private const string EUDriversLicenseNumberValue = "EUDriversLicenseNumber";
        private const string EugpsCoordinatesValue = "EUGPSCoordinates";
        private const string EUNationalIdentificationNumberValue = "EUNationalIdentificationNumber";
        private const string EUPassportNumberValue = "EUPassportNumber";
        private const string EUSocialSecurityNumberValue = "EUSocialSecurityNumber";
        private const string EUTaxIdentificationNumberValue = "EUTaxIdentificationNumber";
        private const string FIEuropeanHealthNumberValue = "FIEuropeanHealthNumber";
        private const string FINationalIDValue = "FINationalID";
        private const string FINationalIDV2Value = "FINationalIDV2";
        private const string FIPassportNumberValue = "FIPassportNumber";
        private const string FRDriversLicenseNumberValue = "FRDriversLicenseNumber";
        private const string FRHealthInsuranceNumberValue = "FRHealthInsuranceNumber";
        private const string FRNationalIDValue = "FRNationalID";
        private const string FRPassportNumberValue = "FRPassportNumber";
        private const string FRSocialSecurityNumberValue = "FRSocialSecurityNumber";
        private const string FRTaxIdentificationNumberValue = "FRTaxIdentificationNumber";
        private const string FRValueAddedTaxNumberValue = "FRValueAddedTaxNumber";
        private const string DEDriversLicenseNumberValue = "DEDriversLicenseNumber";
        private const string DEPassportNumberValue = "DEPassportNumber";
        private const string DEIdentityCardNumberValue = "DEIdentityCardNumber";
        private const string DETaxIdentificationNumberValue = "DETaxIdentificationNumber";
        private const string DEValueAddedNumberValue = "DEValueAddedNumber";
        private const string GRNationalIDCardValue = "GRNationalIDCard";
        private const string GRNationalIDV2Value = "GRNationalIDV2";
        private const string GRTaxIdentificationNumberValue = "GRTaxIdentificationNumber";
        private const string HKIdentityCardNumberValue = "HKIdentityCardNumber";
        private const string HUValueAddedNumberValue = "HUValueAddedNumber";
        private const string HUPersonalIdentificationNumberValue = "HUPersonalIdentificationNumber";
        private const string HUTaxIdentificationNumberValue = "HUTaxIdentificationNumber";
        private const string INPermanentAccountValue = "INPermanentAccount";
        private const string INUniqueIdentificationNumberValue = "INUniqueIdentificationNumber";
        private const string IDIdentityCardNumberValue = "IDIdentityCardNumber";
        private const string InternationalBankingAccountNumberValue = "InternationalBankingAccountNumber";
        private const string IEPersonalPublicServiceNumberValue = "IEPersonalPublicServiceNumber";
        private const string IEPersonalPublicServiceNumberV2Value = "IEPersonalPublicServiceNumberV2";
        private const string ILBankAccountNumberValue = "ILBankAccountNumber";
        private const string ILNationalIDValue = "ILNationalID";
        private const string ITDriversLicenseNumberValue = "ITDriversLicenseNumber";
        private const string ITFiscalCodeValue = "ITFiscalCode";
        private const string ITValueAddedTaxNumberValue = "ITValueAddedTaxNumber";
        private const string JPBankAccountNumberValue = "JPBankAccountNumber";
        private const string JPDriversLicenseNumberValue = "JPDriversLicenseNumber";
        private const string JPPassportNumberValue = "JPPassportNumber";
        private const string JPResidentRegistrationNumberValue = "JPResidentRegistrationNumber";
        private const string JPSocialInsuranceNumberValue = "JPSocialInsuranceNumber";
        private const string JPMyNumberCorporateValue = "JPMyNumberCorporate";
        private const string JPMyNumberPersonalValue = "JPMyNumberPersonal";
        private const string JPResidenceCardNumberValue = "JPResidenceCardNumber";
        private const string LVPersonalCodeValue = "LVPersonalCode";
        private const string LTPersonalCodeValue = "LTPersonalCode";
        private const string LUNationalIdentificationNumberNaturalValue = "LUNationalIdentificationNumberNatural";
        private const string LUNationalIdentificationNumberNonNaturalValue = "LUNationalIdentificationNumberNonNatural";
        private const string MYIdentityCardNumberValue = "MYIdentityCardNumber";
        private const string MTIdentityCardNumberValue = "MTIdentityCardNumber";
        private const string MTTaxIDNumberValue = "MTTaxIDNumber";
        private const string NLCitizensServiceNumberValue = "NLCitizensServiceNumber";
        private const string NLCitizensServiceNumberV2Value = "NLCitizensServiceNumberV2";
        private const string NLTaxIdentificationNumberValue = "NLTaxIdentificationNumber";
        private const string NLValueAddedTaxNumberValue = "NLValueAddedTaxNumber";
        private const string NZBankAccountNumberValue = "NZBankAccountNumber";
        private const string NZDriversLicenseNumberValue = "NZDriversLicenseNumber";
        private const string NZInlandRevenueNumberValue = "NZInlandRevenueNumber";
        private const string NZMinistryOfHealthNumberValue = "NZMinistryOfHealthNumber";
        private const string NZSocialWelfareNumberValue = "NZSocialWelfareNumber";
        private const string NOIdentityNumberValue = "NOIdentityNumber";
        private const string PHUnifiedMultiPurposeIDNumberValue = "PHUnifiedMultiPurposeIDNumber";
        private const string PLIdentityCardValue = "PLIdentityCard";
        private const string PLNationalIDValue = "PLNationalID";
        private const string PLNationalIDV2Value = "PLNationalIDV2";
        private const string PLPassportNumberValue = "PLPassportNumber";
        private const string PLTaxIdentificationNumberValue = "PLTaxIdentificationNumber";
        private const string PlregonNumberValue = "PLREGONNumber";
        private const string PTCitizenCardNumberValue = "PTCitizenCardNumber";
        private const string PTCitizenCardNumberV2Value = "PTCitizenCardNumberV2";
        private const string PTTaxIdentificationNumberValue = "PTTaxIdentificationNumber";
        private const string ROPersonalNumericalCodeValue = "ROPersonalNumericalCode";
        private const string RUPassportNumberDomesticValue = "RUPassportNumberDomestic";
        private const string RUPassportNumberInternationalValue = "RUPassportNumberInternational";
        private const string SANationalIDValue = "SANationalID";
        private const string SGNationalRegistrationIdentityCardNumberValue = "SGNationalRegistrationIdentityCardNumber";
        private const string SKPersonalNumberValue = "SKPersonalNumber";
        private const string SITaxIdentificationNumberValue = "SITaxIdentificationNumber";
        private const string SIUniqueMasterCitizenNumberValue = "SIUniqueMasterCitizenNumber";
        private const string ZAIdentificationNumberValue = "ZAIdentificationNumber";
        private const string KRResidentRegistrationNumberValue = "KRResidentRegistrationNumber";
        private const string EsdniValue = "ESDNI";
        private const string ESSocialSecurityNumberValue = "ESSocialSecurityNumber";
        private const string ESTaxIdentificationNumberValue = "ESTaxIdentificationNumber";
        private const string SQLServerConnectionStringValue = "SQLServerConnectionString";
        private const string SENationalIDValue = "SENationalID";
        private const string SENationalIDV2Value = "SENationalIDV2";
        private const string SEPassportNumberValue = "SEPassportNumber";
        private const string SETaxIdentificationNumberValue = "SETaxIdentificationNumber";
        private const string SwiftCodeValue = "SWIFTCode";
        private const string CHSocialSecurityNumberValue = "CHSocialSecurityNumber";
        private const string TWNationalIDValue = "TWNationalID";
        private const string TWPassportNumberValue = "TWPassportNumber";
        private const string TWResidentCertificateValue = "TWResidentCertificate";
        private const string THPopulationIdentificationCodeValue = "THPopulationIdentificationCode";
        private const string TRNationalIdentificationNumberValue = "TRNationalIdentificationNumber";
        private const string UKDriversLicenseNumberValue = "UKDriversLicenseNumber";
        private const string UKElectoralRollNumberValue = "UKElectoralRollNumber";
        private const string UKNationalHealthNumberValue = "UKNationalHealthNumber";
        private const string UKNationalInsuranceNumberValue = "UKNationalInsuranceNumber";
        private const string UKUniqueTaxpayerNumberValue = "UKUniqueTaxpayerNumber";
        private const string UsukPassportNumberValue = "USUKPassportNumber";
        private const string USBankAccountNumberValue = "USBankAccountNumber";
        private const string USDriversLicenseNumberValue = "USDriversLicenseNumber";
        private const string USIndividualTaxpayerIdentificationValue = "USIndividualTaxpayerIdentification";
        private const string USSocialSecurityNumberValue = "USSocialSecurityNumber";
        private const string UAPassportNumberDomesticValue = "UAPassportNumberDomestic";
        private const string UAPassportNumberInternationalValue = "UAPassportNumberInternational";
        private const string OrganizationValue = "Organization";
        private const string EmailValue = "Email";
        private const string URLValue = "URL";
        private const string AgeValue = "Age";
        private const string PhoneNumberValue = "PhoneNumber";
        private const string IPAddressValue = "IPAddress";
        private const string DateValue = "Date";
        private const string PersonValue = "Person";
        private const string AddressValue = "Address";
        private const string AllValue = "All";
        private const string DefaultValue = "Default";

        /// <summary> ABARoutingNumber. </summary>
        public static PiiEntityLegacyCategory ABARoutingNumber { get; } = new PiiEntityLegacyCategory(ABARoutingNumberValue);
        /// <summary> ARNationalIdentityNumber. </summary>
        public static PiiEntityLegacyCategory ARNationalIdentityNumber { get; } = new PiiEntityLegacyCategory(ARNationalIdentityNumberValue);
        /// <summary> AUBankAccountNumber. </summary>
        public static PiiEntityLegacyCategory AUBankAccountNumber { get; } = new PiiEntityLegacyCategory(AUBankAccountNumberValue);
        /// <summary> AUDriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory AUDriversLicenseNumber { get; } = new PiiEntityLegacyCategory(AUDriversLicenseNumberValue);
        /// <summary> AUMedicalAccountNumber. </summary>
        public static PiiEntityLegacyCategory AUMedicalAccountNumber { get; } = new PiiEntityLegacyCategory(AUMedicalAccountNumberValue);
        /// <summary> AUPassportNumber. </summary>
        public static PiiEntityLegacyCategory AUPassportNumber { get; } = new PiiEntityLegacyCategory(AUPassportNumberValue);
        /// <summary> AUTaxFileNumber. </summary>
        public static PiiEntityLegacyCategory AUTaxFileNumber { get; } = new PiiEntityLegacyCategory(AUTaxFileNumberValue);
        /// <summary> AUBusinessNumber. </summary>
        public static PiiEntityLegacyCategory AUBusinessNumber { get; } = new PiiEntityLegacyCategory(AUBusinessNumberValue);
        /// <summary> AUCompanyNumber. </summary>
        public static PiiEntityLegacyCategory AUCompanyNumber { get; } = new PiiEntityLegacyCategory(AUCompanyNumberValue);
        /// <summary> ATIdentityCard. </summary>
        public static PiiEntityLegacyCategory ATIdentityCard { get; } = new PiiEntityLegacyCategory(ATIdentityCardValue);
        /// <summary> ATTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory ATTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(ATTaxIdentificationNumberValue);
        /// <summary> ATValueAddedTaxNumber. </summary>
        public static PiiEntityLegacyCategory ATValueAddedTaxNumber { get; } = new PiiEntityLegacyCategory(ATValueAddedTaxNumberValue);
        /// <summary> AzureDocumentDBAuthKey. </summary>
        public static PiiEntityLegacyCategory AzureDocumentDBAuthKey { get; } = new PiiEntityLegacyCategory(AzureDocumentDBAuthKeyValue);
        /// <summary> AzureIAASDatabaseConnectionAndSQLString. </summary>
        public static PiiEntityLegacyCategory AzureIaasDatabaseConnectionAndSQLString { get; } = new PiiEntityLegacyCategory(AzureIaasDatabaseConnectionAndSQLStringValue);
        /// <summary> AzureIoTConnectionString. </summary>
        public static PiiEntityLegacyCategory AzureIoTConnectionString { get; } = new PiiEntityLegacyCategory(AzureIoTConnectionStringValue);
        /// <summary> AzurePublishSettingPassword. </summary>
        public static PiiEntityLegacyCategory AzurePublishSettingPassword { get; } = new PiiEntityLegacyCategory(AzurePublishSettingPasswordValue);
        /// <summary> AzureRedisCacheString. </summary>
        public static PiiEntityLegacyCategory AzureRedisCacheString { get; } = new PiiEntityLegacyCategory(AzureRedisCacheStringValue);
        /// <summary> AzureSAS. </summary>
        public static PiiEntityLegacyCategory AzureSAS { get; } = new PiiEntityLegacyCategory(AzureSASValue);
        /// <summary> AzureServiceBusString. </summary>
        public static PiiEntityLegacyCategory AzureServiceBusString { get; } = new PiiEntityLegacyCategory(AzureServiceBusStringValue);
        /// <summary> AzureStorageAccountKey. </summary>
        public static PiiEntityLegacyCategory AzureStorageAccountKey { get; } = new PiiEntityLegacyCategory(AzureStorageAccountKeyValue);
        /// <summary> AzureStorageAccountGeneric. </summary>
        public static PiiEntityLegacyCategory AzureStorageAccountGeneric { get; } = new PiiEntityLegacyCategory(AzureStorageAccountGenericValue);
        /// <summary> BENationalNumber. </summary>
        public static PiiEntityLegacyCategory BENationalNumber { get; } = new PiiEntityLegacyCategory(BENationalNumberValue);
        /// <summary> BENationalNumberV2. </summary>
        public static PiiEntityLegacyCategory BENationalNumberV2 { get; } = new PiiEntityLegacyCategory(BENationalNumberV2Value);
        /// <summary> BEValueAddedTaxNumber. </summary>
        public static PiiEntityLegacyCategory BEValueAddedTaxNumber { get; } = new PiiEntityLegacyCategory(BEValueAddedTaxNumberValue);
        /// <summary> BRCPFNumber. </summary>
        public static PiiEntityLegacyCategory BrcpfNumber { get; } = new PiiEntityLegacyCategory(BrcpfNumberValue);
        /// <summary> BRLegalEntityNumber. </summary>
        public static PiiEntityLegacyCategory BRLegalEntityNumber { get; } = new PiiEntityLegacyCategory(BRLegalEntityNumberValue);
        /// <summary> BRNationalIDRG. </summary>
        public static PiiEntityLegacyCategory BRNationalIdrg { get; } = new PiiEntityLegacyCategory(BRNationalIdrgValue);
        /// <summary> BGUniformCivilNumber. </summary>
        public static PiiEntityLegacyCategory BGUniformCivilNumber { get; } = new PiiEntityLegacyCategory(BGUniformCivilNumberValue);
        /// <summary> CABankAccountNumber. </summary>
        public static PiiEntityLegacyCategory CABankAccountNumber { get; } = new PiiEntityLegacyCategory(CABankAccountNumberValue);
        /// <summary> CADriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory CADriversLicenseNumber { get; } = new PiiEntityLegacyCategory(CADriversLicenseNumberValue);
        /// <summary> CAHealthServiceNumber. </summary>
        public static PiiEntityLegacyCategory CAHealthServiceNumber { get; } = new PiiEntityLegacyCategory(CAHealthServiceNumberValue);
        /// <summary> CAPassportNumber. </summary>
        public static PiiEntityLegacyCategory CAPassportNumber { get; } = new PiiEntityLegacyCategory(CAPassportNumberValue);
        /// <summary> CAPersonalHealthIdentification. </summary>
        public static PiiEntityLegacyCategory CAPersonalHealthIdentification { get; } = new PiiEntityLegacyCategory(CAPersonalHealthIdentificationValue);
        /// <summary> CASocialInsuranceNumber. </summary>
        public static PiiEntityLegacyCategory CASocialInsuranceNumber { get; } = new PiiEntityLegacyCategory(CASocialInsuranceNumberValue);
        /// <summary> CLIdentityCardNumber. </summary>
        public static PiiEntityLegacyCategory CLIdentityCardNumber { get; } = new PiiEntityLegacyCategory(CLIdentityCardNumberValue);
        /// <summary> CNResidentIdentityCardNumber. </summary>
        public static PiiEntityLegacyCategory CNResidentIdentityCardNumber { get; } = new PiiEntityLegacyCategory(CNResidentIdentityCardNumberValue);
        /// <summary> CreditCardNumber. </summary>
        public static PiiEntityLegacyCategory CreditCardNumber { get; } = new PiiEntityLegacyCategory(CreditCardNumberValue);
        /// <summary> HRIdentityCardNumber. </summary>
        public static PiiEntityLegacyCategory HRIdentityCardNumber { get; } = new PiiEntityLegacyCategory(HRIdentityCardNumberValue);
        /// <summary> HRNationalIDNumber. </summary>
        public static PiiEntityLegacyCategory HRNationalIDNumber { get; } = new PiiEntityLegacyCategory(HRNationalIDNumberValue);
        /// <summary> HRPersonalIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory HRPersonalIdentificationNumber { get; } = new PiiEntityLegacyCategory(HRPersonalIdentificationNumberValue);
        /// <summary> HRPersonalIdentificationOIBNumberV2. </summary>
        public static PiiEntityLegacyCategory HRPersonalIdentificationOIBNumberV2 { get; } = new PiiEntityLegacyCategory(HRPersonalIdentificationOIBNumberV2Value);
        /// <summary> CYIdentityCard. </summary>
        public static PiiEntityLegacyCategory CYIdentityCard { get; } = new PiiEntityLegacyCategory(CYIdentityCardValue);
        /// <summary> CYTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory CYTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(CYTaxIdentificationNumberValue);
        /// <summary> CZPersonalIdentityNumber. </summary>
        public static PiiEntityLegacyCategory CZPersonalIdentityNumber { get; } = new PiiEntityLegacyCategory(CZPersonalIdentityNumberValue);
        /// <summary> CZPersonalIdentityV2. </summary>
        public static PiiEntityLegacyCategory CZPersonalIdentityV2 { get; } = new PiiEntityLegacyCategory(CZPersonalIdentityV2Value);
        /// <summary> DKPersonalIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory DKPersonalIdentificationNumber { get; } = new PiiEntityLegacyCategory(DKPersonalIdentificationNumberValue);
        /// <summary> DKPersonalIdentificationV2. </summary>
        public static PiiEntityLegacyCategory DKPersonalIdentificationV2 { get; } = new PiiEntityLegacyCategory(DKPersonalIdentificationV2Value);
        /// <summary> DrugEnforcementAgencyNumber. </summary>
        public static PiiEntityLegacyCategory DrugEnforcementAgencyNumber { get; } = new PiiEntityLegacyCategory(DrugEnforcementAgencyNumberValue);
        /// <summary> EEPersonalIdentificationCode. </summary>
        public static PiiEntityLegacyCategory EEPersonalIdentificationCode { get; } = new PiiEntityLegacyCategory(EEPersonalIdentificationCodeValue);
        /// <summary> EUDebitCardNumber. </summary>
        public static PiiEntityLegacyCategory EUDebitCardNumber { get; } = new PiiEntityLegacyCategory(EUDebitCardNumberValue);
        /// <summary> EUDriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory EUDriversLicenseNumber { get; } = new PiiEntityLegacyCategory(EUDriversLicenseNumberValue);
        /// <summary> EUGPSCoordinates. </summary>
        public static PiiEntityLegacyCategory EugpsCoordinates { get; } = new PiiEntityLegacyCategory(EugpsCoordinatesValue);
        /// <summary> EUNationalIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory EUNationalIdentificationNumber { get; } = new PiiEntityLegacyCategory(EUNationalIdentificationNumberValue);
        /// <summary> EUPassportNumber. </summary>
        public static PiiEntityLegacyCategory EUPassportNumber { get; } = new PiiEntityLegacyCategory(EUPassportNumberValue);
        /// <summary> EUSocialSecurityNumber. </summary>
        public static PiiEntityLegacyCategory EUSocialSecurityNumber { get; } = new PiiEntityLegacyCategory(EUSocialSecurityNumberValue);
        /// <summary> EUTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory EUTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(EUTaxIdentificationNumberValue);
        /// <summary> FIEuropeanHealthNumber. </summary>
        public static PiiEntityLegacyCategory FIEuropeanHealthNumber { get; } = new PiiEntityLegacyCategory(FIEuropeanHealthNumberValue);
        /// <summary> FINationalID. </summary>
        public static PiiEntityLegacyCategory FINationalID { get; } = new PiiEntityLegacyCategory(FINationalIDValue);
        /// <summary> FINationalIDV2. </summary>
        public static PiiEntityLegacyCategory FINationalIDV2 { get; } = new PiiEntityLegacyCategory(FINationalIDV2Value);
        /// <summary> FIPassportNumber. </summary>
        public static PiiEntityLegacyCategory FIPassportNumber { get; } = new PiiEntityLegacyCategory(FIPassportNumberValue);
        /// <summary> FRDriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory FRDriversLicenseNumber { get; } = new PiiEntityLegacyCategory(FRDriversLicenseNumberValue);
        /// <summary> FRHealthInsuranceNumber. </summary>
        public static PiiEntityLegacyCategory FRHealthInsuranceNumber { get; } = new PiiEntityLegacyCategory(FRHealthInsuranceNumberValue);
        /// <summary> FRNationalID. </summary>
        public static PiiEntityLegacyCategory FRNationalID { get; } = new PiiEntityLegacyCategory(FRNationalIDValue);
        /// <summary> FRPassportNumber. </summary>
        public static PiiEntityLegacyCategory FRPassportNumber { get; } = new PiiEntityLegacyCategory(FRPassportNumberValue);
        /// <summary> FRSocialSecurityNumber. </summary>
        public static PiiEntityLegacyCategory FRSocialSecurityNumber { get; } = new PiiEntityLegacyCategory(FRSocialSecurityNumberValue);
        /// <summary> FRTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory FRTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(FRTaxIdentificationNumberValue);
        /// <summary> FRValueAddedTaxNumber. </summary>
        public static PiiEntityLegacyCategory FRValueAddedTaxNumber { get; } = new PiiEntityLegacyCategory(FRValueAddedTaxNumberValue);
        /// <summary> DEDriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory DEDriversLicenseNumber { get; } = new PiiEntityLegacyCategory(DEDriversLicenseNumberValue);
        /// <summary> DEPassportNumber. </summary>
        public static PiiEntityLegacyCategory DEPassportNumber { get; } = new PiiEntityLegacyCategory(DEPassportNumberValue);
        /// <summary> DEIdentityCardNumber. </summary>
        public static PiiEntityLegacyCategory DEIdentityCardNumber { get; } = new PiiEntityLegacyCategory(DEIdentityCardNumberValue);
        /// <summary> DETaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory DETaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(DETaxIdentificationNumberValue);
        /// <summary> DEValueAddedNumber. </summary>
        public static PiiEntityLegacyCategory DEValueAddedNumber { get; } = new PiiEntityLegacyCategory(DEValueAddedNumberValue);
        /// <summary> GRNationalIDCard. </summary>
        public static PiiEntityLegacyCategory GRNationalIDCard { get; } = new PiiEntityLegacyCategory(GRNationalIDCardValue);
        /// <summary> GRNationalIDV2. </summary>
        public static PiiEntityLegacyCategory GRNationalIDV2 { get; } = new PiiEntityLegacyCategory(GRNationalIDV2Value);
        /// <summary> GRTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory GRTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(GRTaxIdentificationNumberValue);
        /// <summary> HKIdentityCardNumber. </summary>
        public static PiiEntityLegacyCategory HKIdentityCardNumber { get; } = new PiiEntityLegacyCategory(HKIdentityCardNumberValue);
        /// <summary> HUValueAddedNumber. </summary>
        public static PiiEntityLegacyCategory HUValueAddedNumber { get; } = new PiiEntityLegacyCategory(HUValueAddedNumberValue);
        /// <summary> HUPersonalIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory HUPersonalIdentificationNumber { get; } = new PiiEntityLegacyCategory(HUPersonalIdentificationNumberValue);
        /// <summary> HUTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory HUTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(HUTaxIdentificationNumberValue);
        /// <summary> INPermanentAccount. </summary>
        public static PiiEntityLegacyCategory INPermanentAccount { get; } = new PiiEntityLegacyCategory(INPermanentAccountValue);
        /// <summary> INUniqueIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory INUniqueIdentificationNumber { get; } = new PiiEntityLegacyCategory(INUniqueIdentificationNumberValue);
        /// <summary> IDIdentityCardNumber. </summary>
        public static PiiEntityLegacyCategory IDIdentityCardNumber { get; } = new PiiEntityLegacyCategory(IDIdentityCardNumberValue);
        /// <summary> InternationalBankingAccountNumber. </summary>
        public static PiiEntityLegacyCategory InternationalBankingAccountNumber { get; } = new PiiEntityLegacyCategory(InternationalBankingAccountNumberValue);
        /// <summary> IEPersonalPublicServiceNumber. </summary>
        public static PiiEntityLegacyCategory IEPersonalPublicServiceNumber { get; } = new PiiEntityLegacyCategory(IEPersonalPublicServiceNumberValue);
        /// <summary> IEPersonalPublicServiceNumberV2. </summary>
        public static PiiEntityLegacyCategory IEPersonalPublicServiceNumberV2 { get; } = new PiiEntityLegacyCategory(IEPersonalPublicServiceNumberV2Value);
        /// <summary> ILBankAccountNumber. </summary>
        public static PiiEntityLegacyCategory ILBankAccountNumber { get; } = new PiiEntityLegacyCategory(ILBankAccountNumberValue);
        /// <summary> ILNationalID. </summary>
        public static PiiEntityLegacyCategory ILNationalID { get; } = new PiiEntityLegacyCategory(ILNationalIDValue);
        /// <summary> ITDriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory ITDriversLicenseNumber { get; } = new PiiEntityLegacyCategory(ITDriversLicenseNumberValue);
        /// <summary> ITFiscalCode. </summary>
        public static PiiEntityLegacyCategory ITFiscalCode { get; } = new PiiEntityLegacyCategory(ITFiscalCodeValue);
        /// <summary> ITValueAddedTaxNumber. </summary>
        public static PiiEntityLegacyCategory ITValueAddedTaxNumber { get; } = new PiiEntityLegacyCategory(ITValueAddedTaxNumberValue);
        /// <summary> JPBankAccountNumber. </summary>
        public static PiiEntityLegacyCategory JPBankAccountNumber { get; } = new PiiEntityLegacyCategory(JPBankAccountNumberValue);
        /// <summary> JPDriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory JPDriversLicenseNumber { get; } = new PiiEntityLegacyCategory(JPDriversLicenseNumberValue);
        /// <summary> JPPassportNumber. </summary>
        public static PiiEntityLegacyCategory JPPassportNumber { get; } = new PiiEntityLegacyCategory(JPPassportNumberValue);
        /// <summary> JPResidentRegistrationNumber. </summary>
        public static PiiEntityLegacyCategory JPResidentRegistrationNumber { get; } = new PiiEntityLegacyCategory(JPResidentRegistrationNumberValue);
        /// <summary> JPSocialInsuranceNumber. </summary>
        public static PiiEntityLegacyCategory JPSocialInsuranceNumber { get; } = new PiiEntityLegacyCategory(JPSocialInsuranceNumberValue);
        /// <summary> JPMyNumberCorporate. </summary>
        public static PiiEntityLegacyCategory JPMyNumberCorporate { get; } = new PiiEntityLegacyCategory(JPMyNumberCorporateValue);
        /// <summary> JPMyNumberPersonal. </summary>
        public static PiiEntityLegacyCategory JPMyNumberPersonal { get; } = new PiiEntityLegacyCategory(JPMyNumberPersonalValue);
        /// <summary> JPResidenceCardNumber. </summary>
        public static PiiEntityLegacyCategory JPResidenceCardNumber { get; } = new PiiEntityLegacyCategory(JPResidenceCardNumberValue);
        /// <summary> LVPersonalCode. </summary>
        public static PiiEntityLegacyCategory LVPersonalCode { get; } = new PiiEntityLegacyCategory(LVPersonalCodeValue);
        /// <summary> LTPersonalCode. </summary>
        public static PiiEntityLegacyCategory LTPersonalCode { get; } = new PiiEntityLegacyCategory(LTPersonalCodeValue);
        /// <summary> LUNationalIdentificationNumberNatural. </summary>
        public static PiiEntityLegacyCategory LUNationalIdentificationNumberNatural { get; } = new PiiEntityLegacyCategory(LUNationalIdentificationNumberNaturalValue);
        /// <summary> LUNationalIdentificationNumberNonNatural. </summary>
        public static PiiEntityLegacyCategory LUNationalIdentificationNumberNonNatural { get; } = new PiiEntityLegacyCategory(LUNationalIdentificationNumberNonNaturalValue);
        /// <summary> MYIdentityCardNumber. </summary>
        public static PiiEntityLegacyCategory MYIdentityCardNumber { get; } = new PiiEntityLegacyCategory(MYIdentityCardNumberValue);
        /// <summary> MTIdentityCardNumber. </summary>
        public static PiiEntityLegacyCategory MTIdentityCardNumber { get; } = new PiiEntityLegacyCategory(MTIdentityCardNumberValue);
        /// <summary> MTTaxIDNumber. </summary>
        public static PiiEntityLegacyCategory MTTaxIDNumber { get; } = new PiiEntityLegacyCategory(MTTaxIDNumberValue);
        /// <summary> NLCitizensServiceNumber. </summary>
        public static PiiEntityLegacyCategory NLCitizensServiceNumber { get; } = new PiiEntityLegacyCategory(NLCitizensServiceNumberValue);
        /// <summary> NLCitizensServiceNumberV2. </summary>
        public static PiiEntityLegacyCategory NLCitizensServiceNumberV2 { get; } = new PiiEntityLegacyCategory(NLCitizensServiceNumberV2Value);
        /// <summary> NLTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory NLTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(NLTaxIdentificationNumberValue);
        /// <summary> NLValueAddedTaxNumber. </summary>
        public static PiiEntityLegacyCategory NLValueAddedTaxNumber { get; } = new PiiEntityLegacyCategory(NLValueAddedTaxNumberValue);
        /// <summary> NZBankAccountNumber. </summary>
        public static PiiEntityLegacyCategory NZBankAccountNumber { get; } = new PiiEntityLegacyCategory(NZBankAccountNumberValue);
        /// <summary> NZDriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory NZDriversLicenseNumber { get; } = new PiiEntityLegacyCategory(NZDriversLicenseNumberValue);
        /// <summary> NZInlandRevenueNumber. </summary>
        public static PiiEntityLegacyCategory NZInlandRevenueNumber { get; } = new PiiEntityLegacyCategory(NZInlandRevenueNumberValue);
        /// <summary> NZMinistryOfHealthNumber. </summary>
        public static PiiEntityLegacyCategory NZMinistryOfHealthNumber { get; } = new PiiEntityLegacyCategory(NZMinistryOfHealthNumberValue);
        /// <summary> NZSocialWelfareNumber. </summary>
        public static PiiEntityLegacyCategory NZSocialWelfareNumber { get; } = new PiiEntityLegacyCategory(NZSocialWelfareNumberValue);
        /// <summary> NOIdentityNumber. </summary>
        public static PiiEntityLegacyCategory NOIdentityNumber { get; } = new PiiEntityLegacyCategory(NOIdentityNumberValue);
        /// <summary> PHUnifiedMultiPurposeIDNumber. </summary>
        public static PiiEntityLegacyCategory PHUnifiedMultiPurposeIDNumber { get; } = new PiiEntityLegacyCategory(PHUnifiedMultiPurposeIDNumberValue);
        /// <summary> PLIdentityCard. </summary>
        public static PiiEntityLegacyCategory PLIdentityCard { get; } = new PiiEntityLegacyCategory(PLIdentityCardValue);
        /// <summary> PLNationalID. </summary>
        public static PiiEntityLegacyCategory PLNationalID { get; } = new PiiEntityLegacyCategory(PLNationalIDValue);
        /// <summary> PLNationalIDV2. </summary>
        public static PiiEntityLegacyCategory PLNationalIDV2 { get; } = new PiiEntityLegacyCategory(PLNationalIDV2Value);
        /// <summary> PLPassportNumber. </summary>
        public static PiiEntityLegacyCategory PLPassportNumber { get; } = new PiiEntityLegacyCategory(PLPassportNumberValue);
        /// <summary> PLTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory PLTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(PLTaxIdentificationNumberValue);
        /// <summary> PLREGONNumber. </summary>
        public static PiiEntityLegacyCategory PlregonNumber { get; } = new PiiEntityLegacyCategory(PlregonNumberValue);
        /// <summary> PTCitizenCardNumber. </summary>
        public static PiiEntityLegacyCategory PTCitizenCardNumber { get; } = new PiiEntityLegacyCategory(PTCitizenCardNumberValue);
        /// <summary> PTCitizenCardNumberV2. </summary>
        public static PiiEntityLegacyCategory PTCitizenCardNumberV2 { get; } = new PiiEntityLegacyCategory(PTCitizenCardNumberV2Value);
        /// <summary> PTTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory PTTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(PTTaxIdentificationNumberValue);
        /// <summary> ROPersonalNumericalCode. </summary>
        public static PiiEntityLegacyCategory ROPersonalNumericalCode { get; } = new PiiEntityLegacyCategory(ROPersonalNumericalCodeValue);
        /// <summary> RUPassportNumberDomestic. </summary>
        public static PiiEntityLegacyCategory RUPassportNumberDomestic { get; } = new PiiEntityLegacyCategory(RUPassportNumberDomesticValue);
        /// <summary> RUPassportNumberInternational. </summary>
        public static PiiEntityLegacyCategory RUPassportNumberInternational { get; } = new PiiEntityLegacyCategory(RUPassportNumberInternationalValue);
        /// <summary> SANationalID. </summary>
        public static PiiEntityLegacyCategory SANationalID { get; } = new PiiEntityLegacyCategory(SANationalIDValue);
        /// <summary> SGNationalRegistrationIdentityCardNumber. </summary>
        public static PiiEntityLegacyCategory SGNationalRegistrationIdentityCardNumber { get; } = new PiiEntityLegacyCategory(SGNationalRegistrationIdentityCardNumberValue);
        /// <summary> SKPersonalNumber. </summary>
        public static PiiEntityLegacyCategory SKPersonalNumber { get; } = new PiiEntityLegacyCategory(SKPersonalNumberValue);
        /// <summary> SITaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory SITaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(SITaxIdentificationNumberValue);
        /// <summary> SIUniqueMasterCitizenNumber. </summary>
        public static PiiEntityLegacyCategory SIUniqueMasterCitizenNumber { get; } = new PiiEntityLegacyCategory(SIUniqueMasterCitizenNumberValue);
        /// <summary> ZAIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory ZAIdentificationNumber { get; } = new PiiEntityLegacyCategory(ZAIdentificationNumberValue);
        /// <summary> KRResidentRegistrationNumber. </summary>
        public static PiiEntityLegacyCategory KRResidentRegistrationNumber { get; } = new PiiEntityLegacyCategory(KRResidentRegistrationNumberValue);
        /// <summary> ESDNI. </summary>
        public static PiiEntityLegacyCategory Esdni { get; } = new PiiEntityLegacyCategory(EsdniValue);
        /// <summary> ESSocialSecurityNumber. </summary>
        public static PiiEntityLegacyCategory ESSocialSecurityNumber { get; } = new PiiEntityLegacyCategory(ESSocialSecurityNumberValue);
        /// <summary> ESTaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory ESTaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(ESTaxIdentificationNumberValue);
        /// <summary> SQLServerConnectionString. </summary>
        public static PiiEntityLegacyCategory SQLServerConnectionString { get; } = new PiiEntityLegacyCategory(SQLServerConnectionStringValue);
        /// <summary> SENationalID. </summary>
        public static PiiEntityLegacyCategory SENationalID { get; } = new PiiEntityLegacyCategory(SENationalIDValue);
        /// <summary> SENationalIDV2. </summary>
        public static PiiEntityLegacyCategory SENationalIDV2 { get; } = new PiiEntityLegacyCategory(SENationalIDV2Value);
        /// <summary> SEPassportNumber. </summary>
        public static PiiEntityLegacyCategory SEPassportNumber { get; } = new PiiEntityLegacyCategory(SEPassportNumberValue);
        /// <summary> SETaxIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory SETaxIdentificationNumber { get; } = new PiiEntityLegacyCategory(SETaxIdentificationNumberValue);
        /// <summary> SWIFTCode. </summary>
        public static PiiEntityLegacyCategory SwiftCode { get; } = new PiiEntityLegacyCategory(SwiftCodeValue);
        /// <summary> CHSocialSecurityNumber. </summary>
        public static PiiEntityLegacyCategory CHSocialSecurityNumber { get; } = new PiiEntityLegacyCategory(CHSocialSecurityNumberValue);
        /// <summary> TWNationalID. </summary>
        public static PiiEntityLegacyCategory TWNationalID { get; } = new PiiEntityLegacyCategory(TWNationalIDValue);
        /// <summary> TWPassportNumber. </summary>
        public static PiiEntityLegacyCategory TWPassportNumber { get; } = new PiiEntityLegacyCategory(TWPassportNumberValue);
        /// <summary> TWResidentCertificate. </summary>
        public static PiiEntityLegacyCategory TWResidentCertificate { get; } = new PiiEntityLegacyCategory(TWResidentCertificateValue);
        /// <summary> THPopulationIdentificationCode. </summary>
        public static PiiEntityLegacyCategory THPopulationIdentificationCode { get; } = new PiiEntityLegacyCategory(THPopulationIdentificationCodeValue);
        /// <summary> TRNationalIdentificationNumber. </summary>
        public static PiiEntityLegacyCategory TRNationalIdentificationNumber { get; } = new PiiEntityLegacyCategory(TRNationalIdentificationNumberValue);
        /// <summary> UKDriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory UKDriversLicenseNumber { get; } = new PiiEntityLegacyCategory(UKDriversLicenseNumberValue);
        /// <summary> UKElectoralRollNumber. </summary>
        public static PiiEntityLegacyCategory UKElectoralRollNumber { get; } = new PiiEntityLegacyCategory(UKElectoralRollNumberValue);
        /// <summary> UKNationalHealthNumber. </summary>
        public static PiiEntityLegacyCategory UKNationalHealthNumber { get; } = new PiiEntityLegacyCategory(UKNationalHealthNumberValue);
        /// <summary> UKNationalInsuranceNumber. </summary>
        public static PiiEntityLegacyCategory UKNationalInsuranceNumber { get; } = new PiiEntityLegacyCategory(UKNationalInsuranceNumberValue);
        /// <summary> UKUniqueTaxpayerNumber. </summary>
        public static PiiEntityLegacyCategory UKUniqueTaxpayerNumber { get; } = new PiiEntityLegacyCategory(UKUniqueTaxpayerNumberValue);
        /// <summary> USUKPassportNumber. </summary>
        public static PiiEntityLegacyCategory UsukPassportNumber { get; } = new PiiEntityLegacyCategory(UsukPassportNumberValue);
        /// <summary> USBankAccountNumber. </summary>
        public static PiiEntityLegacyCategory USBankAccountNumber { get; } = new PiiEntityLegacyCategory(USBankAccountNumberValue);
        /// <summary> USDriversLicenseNumber. </summary>
        public static PiiEntityLegacyCategory USDriversLicenseNumber { get; } = new PiiEntityLegacyCategory(USDriversLicenseNumberValue);
        /// <summary> USIndividualTaxpayerIdentification. </summary>
        public static PiiEntityLegacyCategory USIndividualTaxpayerIdentification { get; } = new PiiEntityLegacyCategory(USIndividualTaxpayerIdentificationValue);
        /// <summary> USSocialSecurityNumber. </summary>
        public static PiiEntityLegacyCategory USSocialSecurityNumber { get; } = new PiiEntityLegacyCategory(USSocialSecurityNumberValue);
        /// <summary> UAPassportNumberDomestic. </summary>
        public static PiiEntityLegacyCategory UAPassportNumberDomestic { get; } = new PiiEntityLegacyCategory(UAPassportNumberDomesticValue);
        /// <summary> UAPassportNumberInternational. </summary>
        public static PiiEntityLegacyCategory UAPassportNumberInternational { get; } = new PiiEntityLegacyCategory(UAPassportNumberInternationalValue);
        /// <summary> Organization. </summary>
        public static PiiEntityLegacyCategory Organization { get; } = new PiiEntityLegacyCategory(OrganizationValue);
        /// <summary> Email. </summary>
        public static PiiEntityLegacyCategory Email { get; } = new PiiEntityLegacyCategory(EmailValue);
        /// <summary> URL. </summary>
        public static PiiEntityLegacyCategory URL { get; } = new PiiEntityLegacyCategory(URLValue);
        /// <summary> Age. </summary>
        public static PiiEntityLegacyCategory Age { get; } = new PiiEntityLegacyCategory(AgeValue);
        /// <summary> PhoneNumber. </summary>
        public static PiiEntityLegacyCategory PhoneNumber { get; } = new PiiEntityLegacyCategory(PhoneNumberValue);
        /// <summary> IPAddress. </summary>
        public static PiiEntityLegacyCategory IPAddress { get; } = new PiiEntityLegacyCategory(IPAddressValue);
        /// <summary> Date. </summary>
        public static PiiEntityLegacyCategory Date { get; } = new PiiEntityLegacyCategory(DateValue);
        /// <summary> Person. </summary>
        public static PiiEntityLegacyCategory Person { get; } = new PiiEntityLegacyCategory(PersonValue);
        /// <summary> Address. </summary>
        public static PiiEntityLegacyCategory Address { get; } = new PiiEntityLegacyCategory(AddressValue);
        /// <summary> All. </summary>
        public static PiiEntityLegacyCategory All { get; } = new PiiEntityLegacyCategory(AllValue);
        /// <summary> Default. </summary>
        public static PiiEntityLegacyCategory Default { get; } = new PiiEntityLegacyCategory(DefaultValue);
        /// <summary> Determines if two <see cref="PiiEntityLegacyCategory"/> values are the same. </summary>
        public static bool operator ==(PiiEntityLegacyCategory left, PiiEntityLegacyCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PiiEntityLegacyCategory"/> values are not the same. </summary>
        public static bool operator !=(PiiEntityLegacyCategory left, PiiEntityLegacyCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PiiEntityLegacyCategory"/>. </summary>
        public static implicit operator PiiEntityLegacyCategory(string value) => new PiiEntityLegacyCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PiiEntityLegacyCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PiiEntityLegacyCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
