// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.TextAnalytics.Legacy
{
    /// <summary> The LanguageInput. </summary>
    internal partial class LanguageInput
    {
        /// <summary> Initializes a new instance of <see cref="LanguageInput"/>. </summary>
        /// <param name="id"> Unique, non-empty document identifier. </param>
        /// <param name="text"></param>
        public LanguageInput(string id, string text)
        {
            Id = id;
            Text = text;
        }

        /// <summary> Initializes a new instance of <see cref="LanguageInput"/>. </summary>
        /// <param name="id"> Unique, non-empty document identifier. </param>
        /// <param name="text"></param>
        /// <param name="countryHint"></param>
        internal LanguageInput(string id, string text, string countryHint)
        {
            Id = id;
            Text = text;
            CountryHint = countryHint;
        }

        /// <summary> Unique, non-empty document identifier. </summary>
        public string Id { get; }
        /// <summary> Gets the text. </summary>
        public string Text { get; }
        /// <summary> Gets or sets the country hint. </summary>
        public string CountryHint { get; set; }
    }
}
