// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.AI.TextAnalytics.Legacy.Models;

namespace Azure.AI.TextAnalytics.Legacy
{
    /// <summary> The JobMetadata. </summary>
    internal partial class JobMetadata
    {
        /// <summary> Initializes a new instance of <see cref="JobMetadata"/>. </summary>
        /// <param name="createdDateTime"></param>
        /// <param name="jobId"></param>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="status"></param>
        internal JobMetadata(DateTimeOffset createdDateTime, Guid jobId, DateTimeOffset lastUpdateDateTime, State status)
        {
            CreatedDateTime = createdDateTime;
            JobId = jobId;
            LastUpdateDateTime = lastUpdateDateTime;
            Status = status;
        }

        /// <summary> Initializes a new instance of <see cref="JobMetadata"/>. </summary>
        /// <param name="createdDateTime"></param>
        /// <param name="expirationDateTime"></param>
        /// <param name="jobId"></param>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="status"></param>
        internal JobMetadata(DateTimeOffset createdDateTime, DateTimeOffset? expirationDateTime, Guid jobId, DateTimeOffset lastUpdateDateTime, State status)
        {
            CreatedDateTime = createdDateTime;
            ExpirationDateTime = expirationDateTime;
            JobId = jobId;
            LastUpdateDateTime = lastUpdateDateTime;
            Status = status;
        }

        /// <summary> Gets the created date time. </summary>
        public DateTimeOffset CreatedDateTime { get; }
        /// <summary> Gets the expiration date time. </summary>
        public DateTimeOffset? ExpirationDateTime { get; }
        /// <summary> Gets the job id. </summary>
        public Guid JobId { get; }
        /// <summary> Gets the last update date time. </summary>
        public DateTimeOffset LastUpdateDateTime { get; }
        /// <summary> Gets the status. </summary>
        public State Status { get; }
    }
}
