// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.TextAnalytics.Legacy
{
    internal partial class JobManifestTasks : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(EntityRecognitionTasks))
            {
                writer.WritePropertyName("entityRecognitionTasks"u8);
                writer.WriteStartArray();
                foreach (var item in EntityRecognitionTasks)
                {
                    writer.WriteObjectValue<EntitiesTask>(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(EntityRecognitionPiiTasks))
            {
                writer.WritePropertyName("entityRecognitionPiiTasks"u8);
                writer.WriteStartArray();
                foreach (var item in EntityRecognitionPiiTasks)
                {
                    writer.WriteObjectValue<PiiTask>(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(KeyPhraseExtractionTasks))
            {
                writer.WritePropertyName("keyPhraseExtractionTasks"u8);
                writer.WriteStartArray();
                foreach (var item in KeyPhraseExtractionTasks)
                {
                    writer.WriteObjectValue<KeyPhrasesTask>(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(EntityLinkingTasks))
            {
                writer.WritePropertyName("entityLinkingTasks"u8);
                writer.WriteStartArray();
                foreach (var item in EntityLinkingTasks)
                {
                    writer.WriteObjectValue<EntityLinkingTask>(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SentimentAnalysisTasks))
            {
                writer.WritePropertyName("sentimentAnalysisTasks"u8);
                writer.WriteStartArray();
                foreach (var item in SentimentAnalysisTasks)
                {
                    writer.WriteObjectValue<SentimentAnalysisTask>(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
