// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.AI.TextAnalytics.Legacy.Models;

namespace Azure.AI.TextAnalytics.Legacy
{
    internal partial class HealthcareRelation
    {
        internal static HealthcareRelation DeserializeHealthcareRelation(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RelationType relationType = default;
            IReadOnlyList<HealthcareRelationEntity> entities = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("relationType"u8))
                {
                    relationType = new RelationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("entities"u8))
                {
                    List<HealthcareRelationEntity> array = new List<HealthcareRelationEntity>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HealthcareRelationEntity.DeserializeHealthcareRelationEntity(item));
                    }
                    entities = array;
                    continue;
                }
            }
            return new HealthcareRelation(relationType, entities);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static HealthcareRelation FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeHealthcareRelation(document.RootElement);
        }
    }
}
