// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.AI.TextAnalytics.Legacy
{
    /// <summary> The HealthcareLinkingProperties. </summary>
    internal partial class HealthcareLinkingProperties
    {
        /// <summary> Initializes a new instance of <see cref="HealthcareLinkingProperties"/>. </summary>
        internal HealthcareLinkingProperties()
        {
            Links = new ChangeTrackingList<HealthcareEntityLink>();
        }

        /// <summary> Initializes a new instance of <see cref="HealthcareLinkingProperties"/>. </summary>
        /// <param name="assertion"></param>
        /// <param name="name"> Preferred name for the entity. Example: 'histologically' would have a 'name' of 'histologic'. </param>
        /// <param name="links"> Entity references in known data sources. </param>
        internal HealthcareLinkingProperties(HealthcareAssertion assertion, string name, IReadOnlyList<HealthcareEntityLink> links)
        {
            Assertion = assertion;
            Name = name;
            Links = links;
        }

        /// <summary> Gets the assertion. </summary>
        public HealthcareAssertion Assertion { get; }
        /// <summary> Preferred name for the entity. Example: 'histologically' would have a 'name' of 'histologic'. </summary>
        public string Name { get; }
        /// <summary> Entity references in known data sources. </summary>
        public IReadOnlyList<HealthcareEntityLink> Links { get; }
    }
}
