// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.TextAnalytics.Legacy
{
    internal partial class HealthcareLinkingProperties
    {
        internal static HealthcareLinkingProperties DeserializeHealthcareLinkingProperties(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            HealthcareAssertion assertion = default;
            string name = default;
            IReadOnlyList<HealthcareEntityLink> links = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("assertion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    assertion = HealthcareAssertion.DeserializeHealthcareAssertion(property.Value);
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("links"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HealthcareEntityLink> array = new List<HealthcareEntityLink>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HealthcareEntityLink.DeserializeHealthcareEntityLink(item));
                    }
                    links = array;
                    continue;
                }
            }
            return new HealthcareLinkingProperties(assertion, name, links ?? new ChangeTrackingList<HealthcareEntityLink>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static HealthcareLinkingProperties FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeHealthcareLinkingProperties(document.RootElement);
        }
    }
}
