// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.AI.TextAnalytics.Legacy.Models;

namespace Azure.AI.TextAnalytics.Legacy
{
    /// <summary> The HealthcareJobState. </summary>
    internal partial class HealthcareJobState : JobMetadata
    {
        /// <summary> Initializes a new instance of <see cref="HealthcareJobState"/>. </summary>
        /// <param name="createdDateTime"></param>
        /// <param name="jobId"></param>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="status"></param>
        internal HealthcareJobState(DateTimeOffset createdDateTime, Guid jobId, DateTimeOffset lastUpdateDateTime, State status) : base(createdDateTime, jobId, lastUpdateDateTime, status)
        {
            Errors = new ChangeTrackingList<TextAnalyticsError>();
        }

        /// <summary> Initializes a new instance of <see cref="HealthcareJobState"/>. </summary>
        /// <param name="createdDateTime"></param>
        /// <param name="expirationDateTime"></param>
        /// <param name="jobId"></param>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="status"></param>
        /// <param name="results"></param>
        /// <param name="errors"></param>
        /// <param name="nextLink"></param>
        internal HealthcareJobState(DateTimeOffset createdDateTime, DateTimeOffset? expirationDateTime, Guid jobId, DateTimeOffset lastUpdateDateTime, State status, HealthcareResult results, IReadOnlyList<TextAnalyticsError> errors, string nextLink) : base(createdDateTime, expirationDateTime, jobId, lastUpdateDateTime, status)
        {
            Results = results;
            Errors = errors;
            NextLink = nextLink;
        }

        /// <summary> Gets the results. </summary>
        public HealthcareResult Results { get; }
        /// <summary> Gets the errors. </summary>
        public IReadOnlyList<TextAnalyticsError> Errors { get; }
        /// <summary> Gets the next link. </summary>
        public string NextLink { get; }
    }
}
