// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.AI.TextAnalytics.Legacy.Models;

namespace Azure.AI.TextAnalytics.Legacy
{
    internal partial class HealthcareAssertion
    {
        internal static HealthcareAssertion DeserializeHealthcareAssertion(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Conditionality? conditionality = default;
            Certainty? certainty = default;
            Association? association = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("conditionality"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    conditionality = property.Value.GetString().ToConditionality();
                    continue;
                }
                if (property.NameEquals("certainty"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    certainty = property.Value.GetString().ToCertainty();
                    continue;
                }
                if (property.NameEquals("association"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    association = property.Value.GetString().ToAssociation();
                    continue;
                }
            }
            return new HealthcareAssertion(conditionality, certainty, association);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static HealthcareAssertion FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeHealthcareAssertion(document.RootElement);
        }
    }
}
