// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.TextAnalytics.Legacy.Models
{
    /// <summary> Error code. </summary>
    internal readonly partial struct ErrorCodeValue : IEquatable<ErrorCodeValue>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ErrorCodeValue"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ErrorCodeValue(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidRequestValue = "InvalidRequest";
        private const string InvalidArgumentValue = "InvalidArgument";
        private const string InternalServerErrorValue = "InternalServerError";
        private const string ServiceUnavailableValue = "ServiceUnavailable";
        private const string NotFoundValue = "NotFound";

        /// <summary> InvalidRequest. </summary>
        public static ErrorCodeValue InvalidRequest { get; } = new ErrorCodeValue(InvalidRequestValue);
        /// <summary> InvalidArgument. </summary>
        public static ErrorCodeValue InvalidArgument { get; } = new ErrorCodeValue(InvalidArgumentValue);
        /// <summary> InternalServerError. </summary>
        public static ErrorCodeValue InternalServerError { get; } = new ErrorCodeValue(InternalServerErrorValue);
        /// <summary> ServiceUnavailable. </summary>
        public static ErrorCodeValue ServiceUnavailable { get; } = new ErrorCodeValue(ServiceUnavailableValue);
        /// <summary> NotFound. </summary>
        public static ErrorCodeValue NotFound { get; } = new ErrorCodeValue(NotFoundValue);
        /// <summary> Determines if two <see cref="ErrorCodeValue"/> values are the same. </summary>
        public static bool operator ==(ErrorCodeValue left, ErrorCodeValue right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ErrorCodeValue"/> values are not the same. </summary>
        public static bool operator !=(ErrorCodeValue left, ErrorCodeValue right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ErrorCodeValue"/>. </summary>
        public static implicit operator ErrorCodeValue(string value) => new ErrorCodeValue(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ErrorCodeValue other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ErrorCodeValue other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
