// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.TextAnalytics.Legacy
{
    /// <summary> The DocumentHealthcareEntities. </summary>
    internal partial class DocumentHealthcareEntities
    {
        /// <summary> Initializes a new instance of <see cref="DocumentHealthcareEntities"/>. </summary>
        /// <param name="id"> Unique, non-empty document identifier. </param>
        /// <param name="entities"> Healthcare entities. </param>
        /// <param name="relations"> Healthcare entity relations. </param>
        /// <param name="warnings"> Warnings encountered while processing document. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/>, <paramref name="entities"/>, <paramref name="relations"/> or <paramref name="warnings"/> is null. </exception>
        internal DocumentHealthcareEntities(string id, IEnumerable<HealthcareEntity> entities, IEnumerable<HealthcareRelation> relations, IEnumerable<TextAnalyticsWarning> warnings)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(entities, nameof(entities));
            Argument.AssertNotNull(relations, nameof(relations));
            Argument.AssertNotNull(warnings, nameof(warnings));

            Id = id;
            Entities = entities.ToList();
            Relations = relations.ToList();
            Warnings = warnings.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="DocumentHealthcareEntities"/>. </summary>
        /// <param name="id"> Unique, non-empty document identifier. </param>
        /// <param name="entities"> Healthcare entities. </param>
        /// <param name="relations"> Healthcare entity relations. </param>
        /// <param name="warnings"> Warnings encountered while processing document. </param>
        /// <param name="statistics"> if showStats=true was specified in the request this field will contain information about the document payload. </param>
        internal DocumentHealthcareEntities(string id, IReadOnlyList<HealthcareEntity> entities, IReadOnlyList<HealthcareRelation> relations, IReadOnlyList<TextAnalyticsWarning> warnings, DocumentStatistics statistics)
        {
            Id = id;
            Entities = entities;
            Relations = relations;
            Warnings = warnings;
            Statistics = statistics;
        }

        /// <summary> Unique, non-empty document identifier. </summary>
        public string Id { get; }
        /// <summary> Healthcare entities. </summary>
        public IReadOnlyList<HealthcareEntity> Entities { get; }
        /// <summary> Healthcare entity relations. </summary>
        public IReadOnlyList<HealthcareRelation> Relations { get; }
        /// <summary> Warnings encountered while processing document. </summary>
        public IReadOnlyList<TextAnalyticsWarning> Warnings { get; }
        /// <summary> if showStats=true was specified in the request this field will contain information about the document payload. </summary>
        public DocumentStatistics Statistics { get; }
    }
}
