// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.TextAnalytics.Legacy.Models
{
    internal static partial class CertaintyExtensions
    {
        public static string ToSerialString(this Certainty value) => value switch
        {
            Certainty.Positive => "positive",
            Certainty.PositivePossible => "positivePossible",
            Certainty.NeutralPossible => "neutralPossible",
            Certainty.NegativePossible => "negativePossible",
            Certainty.Negative => "negative",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown Certainty value.")
        };

        public static Certainty ToCertainty(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "positive")) return Certainty.Positive;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "positivePossible")) return Certainty.PositivePossible;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "neutralPossible")) return Certainty.NeutralPossible;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "negativePossible")) return Certainty.NegativePossible;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "negative")) return Certainty.Negative;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown Certainty value.");
        }
    }
}
