// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.TextAnalytics.Legacy.Models
{
    internal static partial class AssociationExtensions
    {
        public static string ToSerialString(this Association value) => value switch
        {
            Association.Subject => "subject",
            Association.Other => "other",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown Association value.")
        };

        public static Association ToAssociation(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "subject")) return Association.Subject;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "other")) return Association.Other;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown Association value.");
        }
    }
}
