// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.AI.TextAnalytics.Legacy.Models;

namespace Azure.AI.TextAnalytics.Legacy
{
    /// <summary> The AnalyzeJobState. </summary>
    internal partial class AnalyzeJobState : AnalyzeJobMetadata
    {
        /// <summary> Initializes a new instance of <see cref="AnalyzeJobState"/>. </summary>
        /// <param name="createdDateTime"></param>
        /// <param name="jobId"></param>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="status"></param>
        /// <param name="tasks"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="tasks"/> is null. </exception>
        internal AnalyzeJobState(DateTimeOffset createdDateTime, Guid jobId, DateTimeOffset lastUpdateDateTime, State status, TasksStateTasks tasks) : base(createdDateTime, jobId, lastUpdateDateTime, status)
        {
            Argument.AssertNotNull(tasks, nameof(tasks));

            Tasks = tasks;
            Errors = new ChangeTrackingList<TextAnalyticsError>();
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeJobState"/>. </summary>
        /// <param name="createdDateTime"></param>
        /// <param name="expirationDateTime"></param>
        /// <param name="jobId"></param>
        /// <param name="lastUpdateDateTime"></param>
        /// <param name="status"></param>
        /// <param name="displayName"></param>
        /// <param name="tasks"></param>
        /// <param name="errors"></param>
        /// <param name="statistics"> if showStats=true was specified in the request this field will contain information about the request payload. </param>
        /// <param name="nextLink"></param>
        internal AnalyzeJobState(DateTimeOffset createdDateTime, DateTimeOffset? expirationDateTime, Guid jobId, DateTimeOffset lastUpdateDateTime, State status, string displayName, TasksStateTasks tasks, IReadOnlyList<TextAnalyticsError> errors, RequestStatistics statistics, string nextLink) : base(createdDateTime, expirationDateTime, jobId, lastUpdateDateTime, status, displayName)
        {
            Tasks = tasks;
            Errors = errors;
            Statistics = statistics;
            NextLink = nextLink;
        }

        /// <summary> Gets the tasks. </summary>
        public TasksStateTasks Tasks { get; }
        /// <summary> Gets the errors. </summary>
        public IReadOnlyList<TextAnalyticsError> Errors { get; }
        /// <summary> if showStats=true was specified in the request this field will contain information about the request payload. </summary>
        public RequestStatistics Statistics { get; }
        /// <summary> Gets the next link. </summary>
        public string NextLink { get; }
    }
}
