// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Terraform.Models
{
    /// <summary> The Terraform export result. </summary>
    public partial class TerraformExportResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TerraformExportResult"/>. </summary>
        internal TerraformExportResult()
        {
            SkippedResourceIds = new ChangeTrackingList<ResourceIdentifier>();
            Errors = new ChangeTrackingList<ResponseError>();
        }

        /// <summary> Initializes a new instance of <see cref="TerraformExportResult"/>. </summary>
        /// <param name="configuration"> The Terraform configuration content. </param>
        /// <param name="skippedResourceIds"> A list of Azure resources which are not exported to Terraform due to there is no corresponding resources in Terraform. </param>
        /// <param name="errors"> A list of errors derived during exporting each resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TerraformExportResult(string configuration, IReadOnlyList<ResourceIdentifier> skippedResourceIds, IReadOnlyList<ResponseError> errors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Configuration = configuration;
            SkippedResourceIds = skippedResourceIds;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Terraform configuration content. </summary>
        public string Configuration { get; }
        /// <summary> A list of Azure resources which are not exported to Terraform due to there is no corresponding resources in Terraform. </summary>
        public IReadOnlyList<ResourceIdentifier> SkippedResourceIds { get; }
        /// <summary> A list of errors derived during exporting each resource. </summary>
        public IReadOnlyList<ResponseError> Errors { get; }
    }
}
