// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Terraform.Models
{
    /// <summary> The target Azure Terraform Provider. </summary>
    public readonly partial struct TargetTerraformProvider : IEquatable<TargetTerraformProvider>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TargetTerraformProvider"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TargetTerraformProvider(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureRMValue = "azurerm";
        private const string AzApiValue = "azapi";

        /// <summary> https://registry.terraform.io/providers/hashicorp/azurerm/latest. </summary>
        public static TargetTerraformProvider AzureRM { get; } = new TargetTerraformProvider(AzureRMValue);
        /// <summary> https://registry.terraform.io/providers/Azure/azapi/latest. </summary>
        public static TargetTerraformProvider AzApi { get; } = new TargetTerraformProvider(AzApiValue);
        /// <summary> Determines if two <see cref="TargetTerraformProvider"/> values are the same. </summary>
        public static bool operator ==(TargetTerraformProvider left, TargetTerraformProvider right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TargetTerraformProvider"/> values are not the same. </summary>
        public static bool operator !=(TargetTerraformProvider left, TargetTerraformProvider right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TargetTerraformProvider"/>. </summary>
        public static implicit operator TargetTerraformProvider(string value) => new TargetTerraformProvider(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TargetTerraformProvider other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TargetTerraformProvider other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
