// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;

namespace Azure.ResourceManager.Terraform.Models
{
    /// <summary> Export parameter for individual resources. </summary>
    public partial class ExportResourceTerraform : CommonExportProperties
    {
        /// <summary> Initializes a new instance of <see cref="ExportResourceTerraform"/>. </summary>
        /// <param name="resourceIds"> The id of the resource to be exported. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceIds"/> is null. </exception>
        public ExportResourceTerraform(IEnumerable<ResourceIdentifier> resourceIds)
        {
            Argument.AssertNotNull(resourceIds, nameof(resourceIds));

            ResourceIds = resourceIds.ToList();
            Type = CommonExportType.ExportResource;
        }

        /// <summary> Initializes a new instance of <see cref="ExportResourceTerraform"/>. </summary>
        /// <param name="type"> The parameter type. </param>
        /// <param name="targetProvider"> The target Azure Terraform Provider. </param>
        /// <param name="isOutputFullPropertiesEnabled"> Whether to output all non-computed properties in the generated Terraform configuration? This probably needs manual modifications to make it valid. </param>
        /// <param name="isMaskSensitiveEnabled"> Mask sensitive attributes in the Terraform configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="resourceIds"> The id of the resource to be exported. </param>
        /// <param name="resourceName"> The Terraform resource name. Only works when `resourceIds` contains only one item. </param>
        /// <param name="resourceType"> The Terraform resource type. Only works when `resourceIds` contains only one item. </param>
        /// <param name="namePattern"> The name pattern of the Terraform resources. </param>
        internal ExportResourceTerraform(CommonExportType type, TargetTerraformProvider? targetProvider, bool? isOutputFullPropertiesEnabled, bool? isMaskSensitiveEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<ResourceIdentifier> resourceIds, string resourceName, string resourceType, string namePattern) : base(type, targetProvider, isOutputFullPropertiesEnabled, isMaskSensitiveEnabled, serializedAdditionalRawData)
        {
            ResourceIds = resourceIds;
            ResourceName = resourceName;
            ResourceType = resourceType;
            NamePattern = namePattern;
            Type = type;
        }

        /// <summary> Initializes a new instance of <see cref="ExportResourceTerraform"/> for deserialization. </summary>
        internal ExportResourceTerraform()
        {
        }

        /// <summary> The id of the resource to be exported. </summary>
        public IList<ResourceIdentifier> ResourceIds { get; }
        /// <summary> The Terraform resource name. Only works when `resourceIds` contains only one item. </summary>
        public string ResourceName { get; set; }
        /// <summary> The Terraform resource type. Only works when `resourceIds` contains only one item. </summary>
        public string ResourceType { get; set; }
        /// <summary> The name pattern of the Terraform resources. </summary>
        public string NamePattern { get; set; }
    }
}
