// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Terraform.Models
{
    /// <summary> Export parameter for a resource group. </summary>
    public partial class ExportResourceGroupTerraform : CommonExportProperties
    {
        /// <summary> Initializes a new instance of <see cref="ExportResourceGroupTerraform"/>. </summary>
        /// <param name="resourceGroupName"> The name of the resource group to be exported. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupName"/> is null. </exception>
        public ExportResourceGroupTerraform(string resourceGroupName)
        {
            Argument.AssertNotNull(resourceGroupName, nameof(resourceGroupName));

            ResourceGroupName = resourceGroupName;
            Type = CommonExportType.ExportResourceGroup;
        }

        /// <summary> Initializes a new instance of <see cref="ExportResourceGroupTerraform"/>. </summary>
        /// <param name="type"> The parameter type. </param>
        /// <param name="targetProvider"> The target Azure Terraform Provider. </param>
        /// <param name="isOutputFullPropertiesEnabled"> Whether to output all non-computed properties in the generated Terraform configuration? This probably needs manual modifications to make it valid. </param>
        /// <param name="isMaskSensitiveEnabled"> Mask sensitive attributes in the Terraform configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="resourceGroupName"> The name of the resource group to be exported. </param>
        /// <param name="namePattern"> The name pattern of the Terraform resources. </param>
        internal ExportResourceGroupTerraform(CommonExportType type, TargetTerraformProvider? targetProvider, bool? isOutputFullPropertiesEnabled, bool? isMaskSensitiveEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData, string resourceGroupName, string namePattern) : base(type, targetProvider, isOutputFullPropertiesEnabled, isMaskSensitiveEnabled, serializedAdditionalRawData)
        {
            ResourceGroupName = resourceGroupName;
            NamePattern = namePattern;
            Type = type;
        }

        /// <summary> Initializes a new instance of <see cref="ExportResourceGroupTerraform"/> for deserialization. </summary>
        internal ExportResourceGroupTerraform()
        {
        }

        /// <summary> The name of the resource group to be exported. </summary>
        public string ResourceGroupName { get; }
        /// <summary> The name pattern of the Terraform resources. </summary>
        public string NamePattern { get; set; }
    }
}
