// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Terraform.Models
{
    /// <summary> Export parameter for resources queried by ARG (Azure Resource Graph). </summary>
    public partial class ExportQueryTerraform : CommonExportProperties
    {
        /// <summary> Initializes a new instance of <see cref="ExportQueryTerraform"/>. </summary>
        /// <param name="query"> The ARG where predicate. Note that you can combine multiple conditions in one `where` predicate, e.g. `resourceGroup =~ "my-rg" and type =~ "microsoft.network/virtualnetworks"`. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="query"/> is null. </exception>
        public ExportQueryTerraform(string query)
        {
            Argument.AssertNotNull(query, nameof(query));

            Query = query;
            Type = CommonExportType.ExportQuery;
        }

        /// <summary> Initializes a new instance of <see cref="ExportQueryTerraform"/>. </summary>
        /// <param name="type"> The parameter type. </param>
        /// <param name="targetProvider"> The target Azure Terraform Provider. </param>
        /// <param name="isOutputFullPropertiesEnabled"> Whether to output all non-computed properties in the generated Terraform configuration? This probably needs manual modifications to make it valid. </param>
        /// <param name="isMaskSensitiveEnabled"> Mask sensitive attributes in the Terraform configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="query"> The ARG where predicate. Note that you can combine multiple conditions in one `where` predicate, e.g. `resourceGroup =~ "my-rg" and type =~ "microsoft.network/virtualnetworks"`. </param>
        /// <param name="namePattern"> The name pattern of the Terraform resources. </param>
        /// <param name="isRecursive"> Whether to recursively list child resources of the query result. </param>
        internal ExportQueryTerraform(CommonExportType type, TargetTerraformProvider? targetProvider, bool? isOutputFullPropertiesEnabled, bool? isMaskSensitiveEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData, string query, string namePattern, bool? isRecursive) : base(type, targetProvider, isOutputFullPropertiesEnabled, isMaskSensitiveEnabled, serializedAdditionalRawData)
        {
            Query = query;
            NamePattern = namePattern;
            IsRecursive = isRecursive;
            Type = type;
        }

        /// <summary> Initializes a new instance of <see cref="ExportQueryTerraform"/> for deserialization. </summary>
        internal ExportQueryTerraform()
        {
        }

        /// <summary> The ARG where predicate. Note that you can combine multiple conditions in one `where` predicate, e.g. `resourceGroup =~ "my-rg" and type =~ "microsoft.network/virtualnetworks"`. </summary>
        public string Query { get; }
        /// <summary> The name pattern of the Terraform resources. </summary>
        public string NamePattern { get; set; }
        /// <summary> Whether to recursively list child resources of the query result. </summary>
        public bool? IsRecursive { get; set; }
    }
}
