// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Terraform.Models
{
    public partial class ExportQueryTerraform : IUtf8JsonSerializable, IJsonModel<ExportQueryTerraform>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExportQueryTerraform>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExportQueryTerraform>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExportQueryTerraform>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExportQueryTerraform)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("query"u8);
            writer.WriteStringValue(Query);
            if (Optional.IsDefined(NamePattern))
            {
                writer.WritePropertyName("namePattern"u8);
                writer.WriteStringValue(NamePattern);
            }
            if (Optional.IsDefined(IsRecursive))
            {
                writer.WritePropertyName("recursive"u8);
                writer.WriteBooleanValue(IsRecursive.Value);
            }
        }

        ExportQueryTerraform IJsonModel<ExportQueryTerraform>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExportQueryTerraform>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExportQueryTerraform)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExportQueryTerraform(document.RootElement, options);
        }

        internal static ExportQueryTerraform DeserializeExportQueryTerraform(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string query = default;
            string namePattern = default;
            bool? recursive = default;
            CommonExportType type = default;
            TargetTerraformProvider? targetProvider = default;
            bool? fullProperties = default;
            bool? maskSensitive = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("query"u8))
                {
                    query = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("namePattern"u8))
                {
                    namePattern = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recursive"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recursive = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new CommonExportType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetProvider"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetProvider = new TargetTerraformProvider(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("fullProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fullProperties = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("maskSensitive"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maskSensitive = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExportQueryTerraform(
                type,
                targetProvider,
                fullProperties,
                maskSensitive,
                serializedAdditionalRawData,
                query,
                namePattern,
                recursive);
        }

        BinaryData IPersistableModel<ExportQueryTerraform>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExportQueryTerraform>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExportQueryTerraform)} does not support writing '{options.Format}' format.");
            }
        }

        ExportQueryTerraform IPersistableModel<ExportQueryTerraform>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExportQueryTerraform>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExportQueryTerraform(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExportQueryTerraform)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExportQueryTerraform>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
