// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Terraform.Models
{
    /// <summary> The parameter type. </summary>
    internal readonly partial struct CommonExportType : IEquatable<CommonExportType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CommonExportType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CommonExportType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ExportResourceValue = "ExportResource";
        private const string ExportResourceGroupValue = "ExportResourceGroup";
        private const string ExportQueryValue = "ExportQuery";

        /// <summary> ExportResource. </summary>
        public static CommonExportType ExportResource { get; } = new CommonExportType(ExportResourceValue);
        /// <summary> ExportResourceGroup. </summary>
        public static CommonExportType ExportResourceGroup { get; } = new CommonExportType(ExportResourceGroupValue);
        /// <summary> ExportQuery. </summary>
        public static CommonExportType ExportQuery { get; } = new CommonExportType(ExportQueryValue);
        /// <summary> Determines if two <see cref="CommonExportType"/> values are the same. </summary>
        public static bool operator ==(CommonExportType left, CommonExportType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CommonExportType"/> values are not the same. </summary>
        public static bool operator !=(CommonExportType left, CommonExportType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CommonExportType"/>. </summary>
        public static implicit operator CommonExportType(string value) => new CommonExportType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CommonExportType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CommonExportType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
