// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Terraform.Models
{
    /// <summary>
    /// The base export parameter
    /// Please note <see cref="CommonExportProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ExportQueryTerraform"/>, <see cref="ExportResourceTerraform"/> and <see cref="ExportResourceGroupTerraform"/>.
    /// </summary>
    public abstract partial class CommonExportProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CommonExportProperties"/>. </summary>
        protected CommonExportProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CommonExportProperties"/>. </summary>
        /// <param name="type"> The parameter type. </param>
        /// <param name="targetProvider"> The target Azure Terraform Provider. </param>
        /// <param name="isOutputFullPropertiesEnabled"> Whether to output all non-computed properties in the generated Terraform configuration? This probably needs manual modifications to make it valid. </param>
        /// <param name="isMaskSensitiveEnabled"> Mask sensitive attributes in the Terraform configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CommonExportProperties(CommonExportType type, TargetTerraformProvider? targetProvider, bool? isOutputFullPropertiesEnabled, bool? isMaskSensitiveEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Type = type;
            TargetProvider = targetProvider;
            IsOutputFullPropertiesEnabled = isOutputFullPropertiesEnabled;
            IsMaskSensitiveEnabled = isMaskSensitiveEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The parameter type. </summary>
        internal CommonExportType Type { get; set; }
        /// <summary> The target Azure Terraform Provider. </summary>
        public TargetTerraformProvider? TargetProvider { get; set; }
        /// <summary> Whether to output all non-computed properties in the generated Terraform configuration? This probably needs manual modifications to make it valid. </summary>
        public bool? IsOutputFullPropertiesEnabled { get; set; }
        /// <summary> Mask sensitive attributes in the Terraform configuration. </summary>
        public bool? IsMaskSensitiveEnabled { get; set; }
    }
}
