// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Terraform.Models
{
    [PersistableModelProxy(typeof(UnknownCommonExportProperties))]
    public partial class CommonExportProperties : IUtf8JsonSerializable, IJsonModel<CommonExportProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CommonExportProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CommonExportProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CommonExportProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CommonExportProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("type"u8);
            writer.WriteStringValue(Type.ToString());
            if (Optional.IsDefined(TargetProvider))
            {
                writer.WritePropertyName("targetProvider"u8);
                writer.WriteStringValue(TargetProvider.Value.ToString());
            }
            if (Optional.IsDefined(IsOutputFullPropertiesEnabled))
            {
                writer.WritePropertyName("fullProperties"u8);
                writer.WriteBooleanValue(IsOutputFullPropertiesEnabled.Value);
            }
            if (Optional.IsDefined(IsMaskSensitiveEnabled))
            {
                writer.WritePropertyName("maskSensitive"u8);
                writer.WriteBooleanValue(IsMaskSensitiveEnabled.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CommonExportProperties IJsonModel<CommonExportProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CommonExportProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CommonExportProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCommonExportProperties(document.RootElement, options);
        }

        internal static CommonExportProperties DeserializeCommonExportProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("type", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "ExportQuery": return ExportQueryTerraform.DeserializeExportQueryTerraform(element, options);
                    case "ExportResource": return ExportResourceTerraform.DeserializeExportResourceTerraform(element, options);
                    case "ExportResourceGroup": return ExportResourceGroupTerraform.DeserializeExportResourceGroupTerraform(element, options);
                }
            }
            return UnknownCommonExportProperties.DeserializeUnknownCommonExportProperties(element, options);
        }

        BinaryData IPersistableModel<CommonExportProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CommonExportProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CommonExportProperties)} does not support writing '{options.Format}' format.");
            }
        }

        CommonExportProperties IPersistableModel<CommonExportProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CommonExportProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCommonExportProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CommonExportProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CommonExportProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
