// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Terraform.Models;

namespace Azure.ResourceManager.Terraform.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableTerraformSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _terraformClientDiagnostics;
        private TerraformRestOperations _terraformRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableTerraformSubscriptionResource"/> class for mocking. </summary>
        protected MockableTerraformSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableTerraformSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableTerraformSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics TerraformClientDiagnostics => _terraformClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.Terraform", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private TerraformRestOperations TerraformRestClient => _terraformRestClient ??= new TerraformRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Exports the Terraform configuration of the specified resource(s).
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AzureTerraform/exportTerraform</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Terraform_ExportTerraform</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="body"> The request body. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public virtual async Task<ArmOperation<TerraformOperationStatus>> ExportTerraformAsync(WaitUntil waitUntil, CommonExportProperties body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using var scope = TerraformClientDiagnostics.CreateScope("MockableTerraformSubscriptionResource.ExportTerraform");
            scope.Start();
            try
            {
                var response = await TerraformRestClient.ExportTerraformAsync(Id.SubscriptionId, body, cancellationToken).ConfigureAwait(false);
                var operation = new TerraformArmOperation<TerraformOperationStatus>(new TerraformOperationStatusOperationSource(), TerraformClientDiagnostics, Pipeline, TerraformRestClient.CreateExportTerraformRequest(Id.SubscriptionId, body).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Exports the Terraform configuration of the specified resource(s).
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AzureTerraform/exportTerraform</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Terraform_ExportTerraform</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="body"> The request body. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        public virtual ArmOperation<TerraformOperationStatus> ExportTerraform(WaitUntil waitUntil, CommonExportProperties body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using var scope = TerraformClientDiagnostics.CreateScope("MockableTerraformSubscriptionResource.ExportTerraform");
            scope.Start();
            try
            {
                var response = TerraformRestClient.ExportTerraform(Id.SubscriptionId, body, cancellationToken);
                var operation = new TerraformArmOperation<TerraformOperationStatus>(new TerraformOperationStatusOperationSource(), TerraformClientDiagnostics, Pipeline, TerraformRestClient.CreateExportTerraformRequest(Id.SubscriptionId, body).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
