// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;

namespace Azure.ResourceManager.Terraform.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmTerraformModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.ExportQueryTerraform"/>. </summary>
        /// <param name="targetProvider"> The target Azure Terraform Provider. </param>
        /// <param name="isOutputFullPropertiesEnabled"> Whether to output all non-computed properties in the generated Terraform configuration? This probably needs manual modifications to make it valid. </param>
        /// <param name="isMaskSensitiveEnabled"> Mask sensitive attributes in the Terraform configuration. </param>
        /// <param name="query"> The ARG where predicate. Note that you can combine multiple conditions in one `where` predicate, e.g. `resourceGroup =~ "my-rg" and type =~ "microsoft.network/virtualnetworks"`. </param>
        /// <param name="namePattern"> The name pattern of the Terraform resources. </param>
        /// <param name="isRecursive"> Whether to recursively list child resources of the query result. </param>
        /// <returns> A new <see cref="Models.ExportQueryTerraform"/> instance for mocking. </returns>
        public static ExportQueryTerraform ExportQueryTerraform(TargetTerraformProvider? targetProvider = null, bool? isOutputFullPropertiesEnabled = null, bool? isMaskSensitiveEnabled = null, string query = null, string namePattern = null, bool? isRecursive = null)
        {
            return new ExportQueryTerraform(
                CommonExportType.ExportQuery,
                targetProvider,
                isOutputFullPropertiesEnabled,
                isMaskSensitiveEnabled,
                serializedAdditionalRawData: null,
                query,
                namePattern,
                isRecursive);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExportResourceGroupTerraform"/>. </summary>
        /// <param name="targetProvider"> The target Azure Terraform Provider. </param>
        /// <param name="isOutputFullPropertiesEnabled"> Whether to output all non-computed properties in the generated Terraform configuration? This probably needs manual modifications to make it valid. </param>
        /// <param name="isMaskSensitiveEnabled"> Mask sensitive attributes in the Terraform configuration. </param>
        /// <param name="resourceGroupName"> The name of the resource group to be exported. </param>
        /// <param name="namePattern"> The name pattern of the Terraform resources. </param>
        /// <returns> A new <see cref="Models.ExportResourceGroupTerraform"/> instance for mocking. </returns>
        public static ExportResourceGroupTerraform ExportResourceGroupTerraform(TargetTerraformProvider? targetProvider = null, bool? isOutputFullPropertiesEnabled = null, bool? isMaskSensitiveEnabled = null, string resourceGroupName = null, string namePattern = null)
        {
            return new ExportResourceGroupTerraform(
                CommonExportType.ExportResourceGroup,
                targetProvider,
                isOutputFullPropertiesEnabled,
                isMaskSensitiveEnabled,
                serializedAdditionalRawData: null,
                resourceGroupName,
                namePattern);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TerraformOperationStatus"/>. </summary>
        /// <param name="properties"> RP-specific properties for the operationStatus resource, only appears when operation ended with Succeeded status. </param>
        /// <param name="status"> The operation status. </param>
        /// <param name="name"> The name of the  operationStatus resource. </param>
        /// <param name="startOn"> Operation start time. </param>
        /// <param name="endOn"> Operation complete time. </param>
        /// <param name="percentComplete"> The progress made toward completing the operation. </param>
        /// <param name="error"> Errors that occurred if the operation ended with Canceled or Failed status. </param>
        /// <returns> A new <see cref="Models.TerraformOperationStatus"/> instance for mocking. </returns>
        public static TerraformOperationStatus TerraformOperationStatus(TerraformExportResult properties = null, TerraformResourceProvisioningState status = default, string name = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, double? percentComplete = null, ResponseError error = null)
        {
            return new TerraformOperationStatus(
                properties,
                status,
                name,
                startOn,
                endOn,
                percentComplete,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TerraformExportResult"/>. </summary>
        /// <param name="configuration"> The Terraform configuration content. </param>
        /// <param name="skippedResourceIds"> A list of Azure resources which are not exported to Terraform due to there is no corresponding resources in Terraform. </param>
        /// <param name="errors"> A list of errors derived during exporting each resource. </param>
        /// <returns> A new <see cref="Models.TerraformExportResult"/> instance for mocking. </returns>
        public static TerraformExportResult TerraformExportResult(string configuration = null, IEnumerable<ResourceIdentifier> skippedResourceIds = null, IEnumerable<ResponseError> errors = null)
        {
            skippedResourceIds ??= new List<ResourceIdentifier>();
            errors ??= new List<ResponseError>();

            return new TerraformExportResult(configuration, skippedResourceIds?.ToList(), errors?.ToList(), serializedAdditionalRawData: null);
        }
    }
}
