// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Core;

namespace Azure.Template.Models
{
    /// <summary> A secret consisting of a value, id and its attributes. </summary>
    public partial class SecretBundle
    {
        /// <summary> Initializes a new instance of SecretBundle. </summary>
        internal SecretBundle()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of SecretBundle. </summary>
        /// <param name="value"> The secret value. </param>
        /// <param name="id"> The secret id. </param>
        /// <param name="contentType"> The content type of the secret. </param>
        /// <param name="tags"> Application specific metadata in the form of key-value pairs. </param>
        /// <param name="kid"> If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV certificate. </param>
        /// <param name="managed"> True if the secret&apos;s lifetime is managed by key vault. If this is a secret backing a certificate, then managed will be true. </param>
        internal SecretBundle(string value, string id, string contentType, IReadOnlyDictionary<string, string> tags, string kid, bool? managed)
        {
            Value = value;
            Id = id;
            ContentType = contentType;
            Tags = tags;
            Kid = kid;
            Managed = managed;
        }

        /// <summary> The secret value. </summary>
        public string Value { get; }
        /// <summary> The secret id. </summary>
        public string Id { get; }
        /// <summary> The content type of the secret. </summary>
        public string ContentType { get; }
        /// <summary> Application specific metadata in the form of key-value pairs. </summary>
        public IReadOnlyDictionary<string, string> Tags { get; }
        /// <summary> If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV certificate. </summary>
        public string Kid { get; }
        /// <summary> True if the secret&apos;s lifetime is managed by key vault. If this is a secret backing a certificate, then managed will be true. </summary>
        public bool? Managed { get; }
    }
}
