// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Template
{
    /// <summary> Client options for TemplateClient. </summary>
    public partial class TemplateClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V7_0;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "7.0". </summary>
            V7_0 = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of TemplateClientOptions. </summary>
        public TemplateClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V7_0 => "7.0",
                _ => throw new NotSupportedException()
            };
        }
    }
}
