// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core.Extensions;
using Azure.Template;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="TemplateClient"/> to client builder. </summary>
    public static partial class TemplateClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="TemplateClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="vaultBaseUrl"> The vault name, for example https://myvault.vault.azure.net. </param>
        public static IAzureClientBuilder<TemplateClient, TemplateClientOptions> AddTemplateClient<TBuilder>(this TBuilder builder, string vaultBaseUrl)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<TemplateClient, TemplateClientOptions>((options, cred) => new TemplateClient(vaultBaseUrl, cred, options));
        }

        /// <summary> Registers a <see cref="TemplateClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<TemplateClient, TemplateClientOptions> AddTemplateClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<TemplateClient, TemplateClientOptions>(configuration);
        }
    }
}
