// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.Data.Tables
{
    internal partial class TableQueryHeaders
    {
        private readonly Response _response;
        public TableQueryHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> Indicates the version of the Table service used to execute the request. This header is returned for requests made against version 2009-09-19 and above. </summary>
        public string Version => _response.Headers.TryGetValue("x-ms-version", out string value) ? value : null;
        /// <summary> This header contains the continuation token value. </summary>
        public string XMsContinuationNextTableName => _response.Headers.TryGetValue("x-ms-continuation-NextTableName", out string value) ? value : null;
    }
}
