// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Data.Tables.Models
{
    /// <summary> A signed identifier. </summary>
    public partial class TableSignedIdentifier
    {
        /// <summary> Initializes a new instance of <see cref="TableSignedIdentifier"/>. </summary>
        /// <param name="id"> A unique id. </param>
        /// <param name="accessPolicy"> The access policy. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public TableSignedIdentifier(string id, TableAccessPolicy accessPolicy)
        {
            Argument.AssertNotNull(id, nameof(id));

            Id = id;
            AccessPolicy = accessPolicy;
        }

        /// <summary> A unique id. </summary>
        public string Id { get; set; }
        /// <summary> The access policy. </summary>
        public TableAccessPolicy AccessPolicy { get; set; }
    }
}
