// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Xml;
using System.Xml.Linq;
using Azure.Core;

namespace Azure.Data.Tables.Models
{
    public partial class TableSignedIdentifier : IXmlSerializable
    {
        void IXmlSerializable.Write(XmlWriter writer, string nameHint)
        {
            writer.WriteStartElement(nameHint ?? "SignedIdentifier");
            writer.WriteStartElement("Id");
            writer.WriteValue(Id);
            writer.WriteEndElement();
            if (AccessPolicy != null)
            {
                writer.WriteObjectValue(AccessPolicy, "AccessPolicy");
            }
            writer.WriteEndElement();
        }

        internal static TableSignedIdentifier DeserializeTableSignedIdentifier(XElement element)
        {
            string id = default;
            TableAccessPolicy accessPolicy = default;
            if (element.Element("Id") is XElement idElement)
            {
                id = (string)idElement;
            }
            if (element.Element("AccessPolicy") is XElement accessPolicyElement)
            {
                accessPolicy = TableAccessPolicy.DeserializeTableAccessPolicy(accessPolicyElement);
            }
            return new TableSignedIdentifier(id, accessPolicy);
        }
    }
}
