// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Xml;
using System.Xml.Linq;
using Azure.Core;

namespace Azure.Data.Tables.Models
{
    public partial class TableServiceProperties : IXmlSerializable
    {
        void IXmlSerializable.Write(XmlWriter writer, string nameHint)
        {
            writer.WriteStartElement(nameHint ?? "StorageServiceProperties");
            if (Optional.IsDefined(Logging))
            {
                writer.WriteObjectValue(Logging, "Logging");
            }
            if (Optional.IsDefined(HourMetrics))
            {
                writer.WriteObjectValue(HourMetrics, "HourMetrics");
            }
            if (Optional.IsDefined(MinuteMetrics))
            {
                writer.WriteObjectValue(MinuteMetrics, "MinuteMetrics");
            }
            if (Optional.IsCollectionDefined(Cors))
            {
                writer.WriteStartElement("Cors");
                foreach (var item in Cors)
                {
                    writer.WriteObjectValue(item, "CorsRule");
                }
                writer.WriteEndElement();
            }
            writer.WriteEndElement();
        }

        internal static TableServiceProperties DeserializeTableServiceProperties(XElement element)
        {
            TableAnalyticsLoggingSettings logging = default;
            TableMetrics hourMetrics = default;
            TableMetrics minuteMetrics = default;
            IList<TableCorsRule> cors = default;
            if (element.Element("Logging") is XElement loggingElement)
            {
                logging = TableAnalyticsLoggingSettings.DeserializeTableAnalyticsLoggingSettings(loggingElement);
            }
            if (element.Element("HourMetrics") is XElement hourMetricsElement)
            {
                hourMetrics = TableMetrics.DeserializeTableMetrics(hourMetricsElement);
            }
            if (element.Element("MinuteMetrics") is XElement minuteMetricsElement)
            {
                minuteMetrics = TableMetrics.DeserializeTableMetrics(minuteMetricsElement);
            }
            if (element.Element("Cors") is XElement corsElement)
            {
                var array = new List<TableCorsRule>();
                foreach (var e in corsElement.Elements("CorsRule"))
                {
                    array.Add(TableCorsRule.DeserializeTableCorsRule(e));
                }
                cors = array;
            }
            return new TableServiceProperties(logging, hourMetrics, minuteMetrics, cors);
        }
    }
}
