// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Data.Tables.Models
{
    /// <summary> The properties for the table query response. </summary>
    internal partial class TableQueryResponse
    {
        /// <summary> Initializes a new instance of <see cref="TableQueryResponse"/>. </summary>
        internal TableQueryResponse()
        {
            Value = new ChangeTrackingList<TableItem>();
        }

        /// <summary> Initializes a new instance of <see cref="TableQueryResponse"/>. </summary>
        /// <param name="odataMetadata"> The metadata response of the table. </param>
        /// <param name="value"> List of tables. </param>
        internal TableQueryResponse(string odataMetadata, IReadOnlyList<TableItem> value)
        {
            OdataMetadata = odataMetadata;
            Value = value;
        }

        /// <summary> The metadata response of the table. </summary>
        public string OdataMetadata { get; }
        /// <summary> List of tables. </summary>
        public IReadOnlyList<TableItem> Value { get; }
    }
}
