// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Data.Tables.Models
{
    internal partial class TableQueryResponse
    {
        internal static TableQueryResponse DeserializeTableQueryResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string odataMetadata = default;
            IReadOnlyList<TableItem> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("odata.metadata"u8))
                {
                    odataMetadata = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<TableItem> array = new List<TableItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(TableItem.DeserializeTableItem(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new TableQueryResponse(odataMetadata, value ?? new ChangeTrackingList<TableItem>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TableQueryResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTableQueryResponse(document.RootElement);
        }
    }
}
