// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Data.Tables.Models
{
    /// <summary> The status of the secondary location. </summary>
    public readonly partial struct TableGeoReplicationStatus : IEquatable<TableGeoReplicationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TableGeoReplicationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TableGeoReplicationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LiveValue = "live";
        private const string BootstrapValue = "bootstrap";
        private const string UnavailableValue = "unavailable";

        /// <summary> live. </summary>
        public static TableGeoReplicationStatus Live { get; } = new TableGeoReplicationStatus(LiveValue);
        /// <summary> bootstrap. </summary>
        public static TableGeoReplicationStatus Bootstrap { get; } = new TableGeoReplicationStatus(BootstrapValue);
        /// <summary> unavailable. </summary>
        public static TableGeoReplicationStatus Unavailable { get; } = new TableGeoReplicationStatus(UnavailableValue);
        /// <summary> Determines if two <see cref="TableGeoReplicationStatus"/> values are the same. </summary>
        public static bool operator ==(TableGeoReplicationStatus left, TableGeoReplicationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TableGeoReplicationStatus"/> values are not the same. </summary>
        public static bool operator !=(TableGeoReplicationStatus left, TableGeoReplicationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TableGeoReplicationStatus"/>. </summary>
        public static implicit operator TableGeoReplicationStatus(string value) => new TableGeoReplicationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TableGeoReplicationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TableGeoReplicationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
