---
page_type: sample
languages:
- csharp
products:
- azure
- azure-storage
- azure-table-storage
name: Azure Tables samples for .NET
description: Samples for the Azure.Data.Tables client library
---

# Azure Tables client SDK Samples

You can find samples for the most common features of the tables SDK below.
To get started you'll need an Azure Tables endpoint and credentials. See Azure Tables Client Library [Readme](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/tables/Azure.Data.Tables/README.md) for more information and instructions.

* [Create/delete tables](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/tables/Azure.Data.Tables/samples/Sample1CreateDeleteTables.md)
* [Query tables](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/tables/Azure.Data.Tables/samples/Sample3QueryTables.md)
* [Create/delete table entities](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/tables/Azure.Data.Tables/samples/Sample2CreateDeleteEntities.md)
* [Upsert/update table entities](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/tables/Azure.Data.Tables/samples/Sample5UpdateUpsertEntities.md)
* [Query table entities](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/tables/Azure.Data.Tables/samples/Sample4QueryEntities.md)
* [Auth](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/tables/Azure.Data.Tables/samples/Sample0Auth.md): Authenticate with connection strings, shared keys, and shared access signatures0.
* [Transactional batches](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/tables/Azure.Data.Tables/samples/Sample6TransactionalBatch.md)
* [Customizing serialization](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/tables/Azure.Data.Tables/samples/Sample7Serialization.md)
