// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Synapse
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for WorkspaceAclOperations.
    /// </summary>
    public static partial class WorkspaceAclOperationsExtensions
    {
            /// <summary>
            /// Get access control info.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='resource'>
            /// The resource to get the access control info for.
            /// </param>
            public static WorkspaceAccessControlResponse GetAccessControlInfo(this IWorkspaceAclOperations operations, string workspaceName, GetAccessControlInfoRequest resource)
            {
                return operations.GetAccessControlInfoAsync(workspaceName, resource).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get access control info.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='resource'>
            /// The resource to get the access control info for.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<WorkspaceAccessControlResponse> GetAccessControlInfoAsync(this IWorkspaceAclOperations operations, string workspaceName, GetAccessControlInfoRequest resource, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetAccessControlInfoWithHttpMessagesAsync(workspaceName, resource, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Replace Admins of the Workspace.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='request'>
            /// Details of administrators object-ids.
            /// </param>
            public static WorkspaceAccessControlResponse SetWorkspaceAdministrators(this IWorkspaceAclOperations operations, string workspaceName, SetWorkspaceAdministratorsRequest request)
            {
                return operations.SetWorkspaceAdministratorsAsync(workspaceName, request).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Replace Admins of the Workspace.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='request'>
            /// Details of administrators object-ids.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<WorkspaceAccessControlResponse> SetWorkspaceAdministratorsAsync(this IWorkspaceAclOperations operations, string workspaceName, SetWorkspaceAdministratorsRequest request, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SetWorkspaceAdministratorsWithHttpMessagesAsync(workspaceName, request, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
