// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Synapse
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for SparkBatchOperations.
    /// </summary>
    public static partial class SparkBatchOperationsExtensions
    {
            /// <summary>
            /// List all spark batch jobs which are running under a particular spark pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='sparkPoolName'>
            /// Name of the spark pool. "ondemand" targets the ondemand pool.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            /// <param name='detailed'>
            /// Optional query param specifying whether detailed response is returned
            /// beyond plain livy.
            /// </param>
            public static ExtendedLivyListBatchResponse List(this ISparkBatchOperations operations, string workspaceName, string sparkPoolName, int? fromParameter = default(int?), int? size = default(int?), bool? detailed = default(bool?))
            {
                return operations.ListAsync(workspaceName, sparkPoolName, fromParameter, size, detailed).GetAwaiter().GetResult();
            }

            /// <summary>
            /// List all spark batch jobs which are running under a particular spark pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='sparkPoolName'>
            /// Name of the spark pool. "ondemand" targets the ondemand pool.
            /// </param>
            /// <param name='fromParameter'>
            /// Optional param specifying which index the list should begin from.
            /// </param>
            /// <param name='size'>
            /// Optional param specifying the size of the returned list.
            /// By default it is 20 and that is the maximum.
            /// </param>
            /// <param name='detailed'>
            /// Optional query param specifying whether detailed response is returned
            /// beyond plain livy.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ExtendedLivyListBatchResponse> ListAsync(this ISparkBatchOperations operations, string workspaceName, string sparkPoolName, int? fromParameter = default(int?), int? size = default(int?), bool? detailed = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(workspaceName, sparkPoolName, fromParameter, size, detailed, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create new spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='sparkPoolName'>
            /// Name of the spark pool. "ondemand" targets the ondemand pool.
            /// </param>
            /// <param name='livyRequest'>
            /// Livy compatible batch job request payload.
            /// </param>
            /// <param name='detailed'>
            /// Optional query param specifying whether detailed response is returned
            /// beyond plain livy.
            /// </param>
            public static ExtendedLivyBatchResponse Create(this ISparkBatchOperations operations, string workspaceName, string sparkPoolName, ExtendedLivyBatchRequest livyRequest, bool? detailed = default(bool?))
            {
                return operations.CreateAsync(workspaceName, sparkPoolName, livyRequest, detailed).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create new spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='sparkPoolName'>
            /// Name of the spark pool. "ondemand" targets the ondemand pool.
            /// </param>
            /// <param name='livyRequest'>
            /// Livy compatible batch job request payload.
            /// </param>
            /// <param name='detailed'>
            /// Optional query param specifying whether detailed response is returned
            /// beyond plain livy.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ExtendedLivyBatchResponse> CreateAsync(this ISparkBatchOperations operations, string workspaceName, string sparkPoolName, ExtendedLivyBatchRequest livyRequest, bool? detailed = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateWithHttpMessagesAsync(workspaceName, sparkPoolName, livyRequest, detailed, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets a single spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='sparkPoolName'>
            /// Name of the spark pool. "ondemand" targets the ondemand pool.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            /// <param name='detailed'>
            /// Optional query param specifying whether detailed response is returned
            /// beyond plain livy.
            /// </param>
            public static ExtendedLivyBatchResponse Get(this ISparkBatchOperations operations, string workspaceName, string sparkPoolName, int batchId, bool? detailed = default(bool?))
            {
                return operations.GetAsync(workspaceName, sparkPoolName, batchId, detailed).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets a single spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='sparkPoolName'>
            /// Name of the spark pool. "ondemand" targets the ondemand pool.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            /// <param name='detailed'>
            /// Optional query param specifying whether detailed response is returned
            /// beyond plain livy.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ExtendedLivyBatchResponse> GetAsync(this ISparkBatchOperations operations, string workspaceName, string sparkPoolName, int batchId, bool? detailed = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(workspaceName, sparkPoolName, batchId, detailed, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Cancels a running spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='sparkPoolName'>
            /// Name of the spark pool. "ondemand" targets the ondemand pool.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            public static void Delete(this ISparkBatchOperations operations, string workspaceName, string sparkPoolName, int batchId)
            {
                operations.DeleteAsync(workspaceName, sparkPoolName, batchId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Cancels a running spark batch job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='sparkPoolName'>
            /// Name of the spark pool. "ondemand" targets the ondemand pool.
            /// </param>
            /// <param name='batchId'>
            /// Identifier for the batch job.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteAsync(this ISparkBatchOperations operations, string workspaceName, string sparkPoolName, int batchId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteWithHttpMessagesAsync(workspaceName, sparkPoolName, batchId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

    }
}
