// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Synapse
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for MonitoringOperations.
    /// </summary>
    public static partial class MonitoringOperationsExtensions
    {
            /// <summary>
            /// Get History Server Data for a given workspace, pool, livyid, appid and
            /// attemptId
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='poolName'>
            /// The spark pool name.
            /// </param>
            /// <param name='livyId'>
            /// The livy id.
            /// </param>
            /// <param name='appId'>
            /// The application id.
            /// </param>
            /// <param name='attemptId'>
            /// The attempt id.
            /// </param>
            public static HistoryServerDataResponse GetHistoryServerData(this IMonitoringOperations operations, string workspaceName, string poolName, string livyId, string appId, string attemptId)
            {
                return operations.GetHistoryServerDataAsync(workspaceName, poolName, livyId, appId, attemptId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get History Server Data for a given workspace, pool, livyid, appid and
            /// attemptId
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='poolName'>
            /// The spark pool name.
            /// </param>
            /// <param name='livyId'>
            /// The livy id.
            /// </param>
            /// <param name='appId'>
            /// The application id.
            /// </param>
            /// <param name='attemptId'>
            /// The attempt id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<HistoryServerDataResponse> GetHistoryServerDataAsync(this IMonitoringOperations operations, string workspaceName, string poolName, string livyId, string appId, string attemptId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetHistoryServerDataWithHttpMessagesAsync(workspaceName, poolName, livyId, appId, attemptId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get list of spark applications for the workspace.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            public static SparkJobListViewResponse GetSparkJobList(this IMonitoringOperations operations, string workspaceName)
            {
                return operations.GetSparkJobListAsync(workspaceName).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get list of spark applications for the workspace.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkJobListViewResponse> GetSparkJobListAsync(this IMonitoringOperations operations, string workspaceName, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetSparkJobListWithHttpMessagesAsync(workspaceName, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get one spark application details given the workspace name, pool name and
            /// livyid.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='poolName'>
            /// The spark pool name.
            /// </param>
            /// <param name='livyId'>
            /// The livy id.
            /// </param>
            public static SparkJobListViewResponse GetApplicationDetails(this IMonitoringOperations operations, string workspaceName, string poolName, string livyId)
            {
                return operations.GetApplicationDetailsAsync(workspaceName, poolName, livyId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get one spark application details given the workspace name, pool name and
            /// livyid.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='poolName'>
            /// The spark pool name.
            /// </param>
            /// <param name='livyId'>
            /// The livy id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SparkJobListViewResponse> GetApplicationDetailsAsync(this IMonitoringOperations operations, string workspaceName, string poolName, string livyId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetApplicationDetailsWithHttpMessagesAsync(workspaceName, poolName, livyId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get History server properties.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            public static HistoryServerPropertiesResponse GetHistoryServerProperties(this IMonitoringOperations operations, string workspaceName)
            {
                return operations.GetHistoryServerPropertiesAsync(workspaceName).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get History server properties.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<HistoryServerPropertiesResponse> GetHistoryServerPropertiesAsync(this IMonitoringOperations operations, string workspaceName, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetHistoryServerPropertiesWithHttpMessagesAsync(workspaceName, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get History Server Diagnostic Data for a given workspace, pool, livyid,
            /// appid and attemptId
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='poolName'>
            /// The spark pool name.
            /// </param>
            /// <param name='livyId'>
            /// The livy id.
            /// </param>
            /// <param name='appId'>
            /// The application id.
            /// </param>
            /// <param name='attemptId'>
            /// The attempt id.
            /// </param>
            public static HistoryServerDiagnosticResponse GetHistoryServerDiagnostic(this IMonitoringOperations operations, string workspaceName, string poolName, string livyId, string appId, string attemptId)
            {
                return operations.GetHistoryServerDiagnosticAsync(workspaceName, poolName, livyId, appId, attemptId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get History Server Diagnostic Data for a given workspace, pool, livyid,
            /// appid and attemptId
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='poolName'>
            /// The spark pool name.
            /// </param>
            /// <param name='livyId'>
            /// The livy id.
            /// </param>
            /// <param name='appId'>
            /// The application id.
            /// </param>
            /// <param name='attemptId'>
            /// The attempt id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<HistoryServerDiagnosticResponse> GetHistoryServerDiagnosticAsync(this IMonitoringOperations operations, string workspaceName, string poolName, string livyId, string appId, string attemptId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetHistoryServerDiagnosticWithHttpMessagesAsync(workspaceName, poolName, livyId, appId, attemptId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get History Server Graph Data for a given workspace, pool, livyid, appid
            /// and attemptId
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='poolName'>
            /// The spark pool name.
            /// </param>
            /// <param name='livyId'>
            /// The livy id.
            /// </param>
            /// <param name='appId'>
            /// The application id.
            /// </param>
            /// <param name='attemptId'>
            /// The attempt id.
            /// </param>
            public static HistoryServerGraphResponse GetHistoryServerGraph(this IMonitoringOperations operations, string workspaceName, string poolName, string livyId, string appId, string attemptId)
            {
                return operations.GetHistoryServerGraphAsync(workspaceName, poolName, livyId, appId, attemptId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get History Server Graph Data for a given workspace, pool, livyid, appid
            /// and attemptId
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='workspaceName'>
            /// The name of the workspace to execute operations on.
            /// </param>
            /// <param name='poolName'>
            /// The spark pool name.
            /// </param>
            /// <param name='livyId'>
            /// The livy id.
            /// </param>
            /// <param name='appId'>
            /// The application id.
            /// </param>
            /// <param name='attemptId'>
            /// The attempt id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<HistoryServerGraphResponse> GetHistoryServerGraphAsync(this IMonitoringOperations operations, string workspaceName, string poolName, string livyId, string appId, string attemptId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetHistoryServerGraphWithHttpMessagesAsync(workspaceName, poolName, livyId, appId, attemptId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
