// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Synapse
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// SparkBatchOperations operations.
    /// </summary>
    public partial interface ISparkBatchOperations
    {
        /// <summary>
        /// List all spark batch jobs which are running under a particular
        /// spark pool.
        /// </summary>
        /// <param name='workspaceName'>
        /// The name of the workspace to execute operations on.
        /// </param>
        /// <param name='sparkPoolName'>
        /// Name of the spark pool. "ondemand" targets the ondemand pool.
        /// </param>
        /// <param name='fromParameter'>
        /// Optional param specifying which index the list should begin from.
        /// </param>
        /// <param name='size'>
        /// Optional param specifying the size of the returned list.
        /// By default it is 20 and that is the maximum.
        /// </param>
        /// <param name='detailed'>
        /// Optional query param specifying whether detailed response is
        /// returned beyond plain livy.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="Microsoft.Rest.Azure.CloudException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<ExtendedLivyListBatchResponse>> ListWithHttpMessagesAsync(string workspaceName, string sparkPoolName, int? fromParameter = default(int?), int? size = default(int?), bool? detailed = default(bool?), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Create new spark batch job.
        /// </summary>
        /// <param name='workspaceName'>
        /// The name of the workspace to execute operations on.
        /// </param>
        /// <param name='sparkPoolName'>
        /// Name of the spark pool. "ondemand" targets the ondemand pool.
        /// </param>
        /// <param name='livyRequest'>
        /// Livy compatible batch job request payload.
        /// </param>
        /// <param name='detailed'>
        /// Optional query param specifying whether detailed response is
        /// returned beyond plain livy.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="Microsoft.Rest.Azure.CloudException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<ExtendedLivyBatchResponse>> CreateWithHttpMessagesAsync(string workspaceName, string sparkPoolName, ExtendedLivyBatchRequest livyRequest, bool? detailed = default(bool?), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Gets a single spark batch job.
        /// </summary>
        /// <param name='workspaceName'>
        /// The name of the workspace to execute operations on.
        /// </param>
        /// <param name='sparkPoolName'>
        /// Name of the spark pool. "ondemand" targets the ondemand pool.
        /// </param>
        /// <param name='batchId'>
        /// Identifier for the batch job.
        /// </param>
        /// <param name='detailed'>
        /// Optional query param specifying whether detailed response is
        /// returned beyond plain livy.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="Microsoft.Rest.Azure.CloudException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<ExtendedLivyBatchResponse>> GetWithHttpMessagesAsync(string workspaceName, string sparkPoolName, int batchId, bool? detailed = default(bool?), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Cancels a running spark batch job.
        /// </summary>
        /// <param name='workspaceName'>
        /// The name of the workspace to execute operations on.
        /// </param>
        /// <param name='sparkPoolName'>
        /// Name of the spark pool. "ondemand" targets the ondemand pool.
        /// </param>
        /// <param name='batchId'>
        /// Identifier for the batch job.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="Microsoft.Rest.Azure.CloudException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse> DeleteWithHttpMessagesAsync(string workspaceName, string sparkPoolName, int batchId, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
    }
}
