// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing the SynapseVulnerabilityAssessmentScanRecord data model.
    /// A vulnerability assessment scan record.
    /// </summary>
    public partial class SynapseVulnerabilityAssessmentScanRecordData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SynapseVulnerabilityAssessmentScanRecordData"/>. </summary>
        public SynapseVulnerabilityAssessmentScanRecordData()
        {
            Errors = new ChangeTrackingList<SynapseVulnerabilityAssessmentScanError>();
        }

        /// <summary> Initializes a new instance of <see cref="SynapseVulnerabilityAssessmentScanRecordData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scanId"> The scan ID. </param>
        /// <param name="triggerType"> The scan trigger type. </param>
        /// <param name="state"> The scan status. </param>
        /// <param name="startOn"> The scan start time (UTC). </param>
        /// <param name="endOn"> The scan end time (UTC). </param>
        /// <param name="errors"> The scan errors. </param>
        /// <param name="storageContainerPath"> The scan results storage container path. </param>
        /// <param name="numberOfFailedSecurityChecks"> The number of failed security checks. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SynapseVulnerabilityAssessmentScanRecordData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string scanId, SynapseVulnerabilityAssessmentScanTriggerType? triggerType, SynapseVulnerabilityAssessmentScanState? state, DateTimeOffset? startOn, DateTimeOffset? endOn, IReadOnlyList<SynapseVulnerabilityAssessmentScanError> errors, string storageContainerPath, int? numberOfFailedSecurityChecks, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ScanId = scanId;
            TriggerType = triggerType;
            State = state;
            StartOn = startOn;
            EndOn = endOn;
            Errors = errors;
            StorageContainerPath = storageContainerPath;
            NumberOfFailedSecurityChecks = numberOfFailedSecurityChecks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The scan ID. </summary>
        public string ScanId { get; }
        /// <summary> The scan trigger type. </summary>
        public SynapseVulnerabilityAssessmentScanTriggerType? TriggerType { get; }
        /// <summary> The scan status. </summary>
        public SynapseVulnerabilityAssessmentScanState? State { get; }
        /// <summary> The scan start time (UTC). </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> The scan end time (UTC). </summary>
        public DateTimeOffset? EndOn { get; }
        /// <summary> The scan errors. </summary>
        public IReadOnlyList<SynapseVulnerabilityAssessmentScanError> Errors { get; }
        /// <summary> The scan results storage container path. </summary>
        public string StorageContainerPath { get; }
        /// <summary> The number of failed security checks. </summary>
        public int? NumberOfFailedSecurityChecks { get; }
    }
}
