// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    public partial class SynapseVulnerabilityAssessmentScanRecordData : IUtf8JsonSerializable, IJsonModel<SynapseVulnerabilityAssessmentScanRecordData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SynapseVulnerabilityAssessmentScanRecordData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SynapseVulnerabilityAssessmentScanRecordData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseVulnerabilityAssessmentScanRecordData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseVulnerabilityAssessmentScanRecordData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ScanId))
            {
                writer.WritePropertyName("scanId"u8);
                writer.WriteStringValue(ScanId);
            }
            if (options.Format != "W" && Optional.IsDefined(TriggerType))
            {
                writer.WritePropertyName("triggerType"u8);
                writer.WriteStringValue(TriggerType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startTime"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(EndOn))
            {
                writer.WritePropertyName("endTime"u8);
                writer.WriteStringValue(EndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Errors))
            {
                writer.WritePropertyName("errors"u8);
                writer.WriteStartArray();
                foreach (var item in Errors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(StorageContainerPath))
            {
                writer.WritePropertyName("storageContainerPath"u8);
                writer.WriteStringValue(StorageContainerPath);
            }
            if (options.Format != "W" && Optional.IsDefined(NumberOfFailedSecurityChecks))
            {
                writer.WritePropertyName("numberOfFailedSecurityChecks"u8);
                writer.WriteNumberValue(NumberOfFailedSecurityChecks.Value);
            }
            writer.WriteEndObject();
        }

        SynapseVulnerabilityAssessmentScanRecordData IJsonModel<SynapseVulnerabilityAssessmentScanRecordData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseVulnerabilityAssessmentScanRecordData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseVulnerabilityAssessmentScanRecordData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSynapseVulnerabilityAssessmentScanRecordData(document.RootElement, options);
        }

        internal static SynapseVulnerabilityAssessmentScanRecordData DeserializeSynapseVulnerabilityAssessmentScanRecordData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string scanId = default;
            SynapseVulnerabilityAssessmentScanTriggerType? triggerType = default;
            SynapseVulnerabilityAssessmentScanState? state = default;
            DateTimeOffset? startTime = default;
            DateTimeOffset? endTime = default;
            IReadOnlyList<SynapseVulnerabilityAssessmentScanError> errors = default;
            string storageContainerPath = default;
            int? numberOfFailedSecurityChecks = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("scanId"u8))
                        {
                            scanId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("triggerType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            triggerType = new SynapseVulnerabilityAssessmentScanTriggerType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new SynapseVulnerabilityAssessmentScanState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("startTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            startTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("endTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            endTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("errors"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SynapseVulnerabilityAssessmentScanError> array = new List<SynapseVulnerabilityAssessmentScanError>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SynapseVulnerabilityAssessmentScanError.DeserializeSynapseVulnerabilityAssessmentScanError(item, options));
                            }
                            errors = array;
                            continue;
                        }
                        if (property0.NameEquals("storageContainerPath"u8))
                        {
                            storageContainerPath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("numberOfFailedSecurityChecks"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            numberOfFailedSecurityChecks = property0.Value.GetInt32();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SynapseVulnerabilityAssessmentScanRecordData(
                id,
                name,
                type,
                systemData,
                scanId,
                triggerType,
                state,
                startTime,
                endTime,
                errors ?? new ChangeTrackingList<SynapseVulnerabilityAssessmentScanError>(),
                storageContainerPath,
                numberOfFailedSecurityChecks,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SynapseVulnerabilityAssessmentScanRecordData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseVulnerabilityAssessmentScanRecordData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SynapseVulnerabilityAssessmentScanRecordData)} does not support writing '{options.Format}' format.");
            }
        }

        SynapseVulnerabilityAssessmentScanRecordData IPersistableModel<SynapseVulnerabilityAssessmentScanRecordData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseVulnerabilityAssessmentScanRecordData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSynapseVulnerabilityAssessmentScanRecordData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SynapseVulnerabilityAssessmentScanRecordData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SynapseVulnerabilityAssessmentScanRecordData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
