// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing a collection of <see cref="SynapseVulnerabilityAssessmentScanRecordResource"/> and their operations.
    /// Each <see cref="SynapseVulnerabilityAssessmentScanRecordResource"/> in the collection will belong to the same instance of <see cref="SynapseSqlPoolVulnerabilityAssessmentResource"/>.
    /// To get a <see cref="SynapseVulnerabilityAssessmentScanRecordCollection"/> instance call the GetSynapseVulnerabilityAssessmentScanRecords method from an instance of <see cref="SynapseSqlPoolVulnerabilityAssessmentResource"/>.
    /// </summary>
    public partial class SynapseVulnerabilityAssessmentScanRecordCollection : ArmCollection, IEnumerable<SynapseVulnerabilityAssessmentScanRecordResource>, IAsyncEnumerable<SynapseVulnerabilityAssessmentScanRecordResource>
    {
        private readonly ClientDiagnostics _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics;
        private readonly SqlPoolVulnerabilityAssessmentScansRestOperations _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient;

        /// <summary> Initializes a new instance of the <see cref="SynapseVulnerabilityAssessmentScanRecordCollection"/> class for mocking. </summary>
        protected SynapseVulnerabilityAssessmentScanRecordCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseVulnerabilityAssessmentScanRecordCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SynapseVulnerabilityAssessmentScanRecordCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseVulnerabilityAssessmentScanRecordResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SynapseVulnerabilityAssessmentScanRecordResource.ResourceType, out string synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansApiVersion);
            _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient = new SqlPoolVulnerabilityAssessmentScansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SynapseSqlPoolVulnerabilityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SynapseSqlPoolVulnerabilityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a Sql pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseVulnerabilityAssessmentScanRecordResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<SynapseVulnerabilityAssessmentScanRecordResource>> GetAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SynapseVulnerabilityAssessmentScanRecordCollection.Get");
            scope.Start();
            try
            {
                var response = await _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseVulnerabilityAssessmentScanRecordResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a Sql pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseVulnerabilityAssessmentScanRecordResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<SynapseVulnerabilityAssessmentScanRecordResource> Get(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SynapseVulnerabilityAssessmentScanRecordCollection.Get");
            scope.Start();
            try
            {
                var response = _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseVulnerabilityAssessmentScanRecordResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a SQL pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentScans_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseVulnerabilityAssessmentScanRecordResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SynapseVulnerabilityAssessmentScanRecordResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SynapseVulnerabilityAssessmentScanRecordResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SynapseVulnerabilityAssessmentScanRecordResource(Client, SynapseVulnerabilityAssessmentScanRecordData.DeserializeSynapseVulnerabilityAssessmentScanRecordData(e)), _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics, Pipeline, "SynapseVulnerabilityAssessmentScanRecordCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a SQL pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentScans_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseVulnerabilityAssessmentScanRecordResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SynapseVulnerabilityAssessmentScanRecordResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SynapseVulnerabilityAssessmentScanRecordResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SynapseVulnerabilityAssessmentScanRecordResource(Client, SynapseVulnerabilityAssessmentScanRecordData.DeserializeSynapseVulnerabilityAssessmentScanRecordData(e)), _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics, Pipeline, "SynapseVulnerabilityAssessmentScanRecordCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseVulnerabilityAssessmentScanRecordResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SynapseVulnerabilityAssessmentScanRecordCollection.Exists");
            scope.Start();
            try
            {
                var response = await _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseVulnerabilityAssessmentScanRecordResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<bool> Exists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SynapseVulnerabilityAssessmentScanRecordCollection.Exists");
            scope.Start();
            try
            {
                var response = _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseVulnerabilityAssessmentScanRecordResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<NullableResponse<SynapseVulnerabilityAssessmentScanRecordResource>> GetIfExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SynapseVulnerabilityAssessmentScanRecordCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SynapseVulnerabilityAssessmentScanRecordResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseVulnerabilityAssessmentScanRecordResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseVulnerabilityAssessmentScanRecordResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual NullableResponse<SynapseVulnerabilityAssessmentScanRecordResource> GetIfExists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SynapseVulnerabilityAssessmentScanRecordCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _synapseVulnerabilityAssessmentScanRecordSqlPoolVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SynapseVulnerabilityAssessmentScanRecordResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseVulnerabilityAssessmentScanRecordResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SynapseVulnerabilityAssessmentScanRecordResource> IEnumerable<SynapseVulnerabilityAssessmentScanRecordResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SynapseVulnerabilityAssessmentScanRecordResource> IAsyncEnumerable<SynapseVulnerabilityAssessmentScanRecordResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
