// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A Class representing a SynapseSqlPoolVulnerabilityAssessmentRuleBaseline along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource method.
    /// Otherwise you can get one from its parent resource <see cref="SynapseSqlPoolVulnerabilityAssessmentResource"/> using the GetSynapseSqlPoolVulnerabilityAssessmentRuleBaseline method.
    /// </summary>
    public partial class SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="workspaceName"> The workspaceName. </param>
        /// <param name="sqlPoolName"> The sqlPoolName. </param>
        /// <param name="vulnerabilityAssessmentName"> The vulnerabilityAssessmentName. </param>
        /// <param name="ruleId"> The ruleId. </param>
        /// <param name="baselineName"> The baselineName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics;
        private readonly SqlPoolVulnerabilityAssessmentRuleBaselinesRestOperations _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient;
        private readonly SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/rules/baselines";

        /// <summary> Initializes a new instance of the <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/> class for mocking. </summary>
        protected SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(ArmClient client, SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesApiVersion);
            _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient = new SqlPoolVulnerabilityAssessmentRuleBaselinesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a SqlPool's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.Get");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName(), cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a SqlPool's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.Get");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName(), cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes the database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.Delete");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName(), cancellationToken).ConfigureAwait(false);
                var uri = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName());
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SynapseArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes the database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.Delete");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName(), cancellationToken);
                var uri = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName());
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SynapseArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a Sql pool's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>> UpdateAsync(WaitUntil waitUntil, SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.Update");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName(), data, cancellationToken).ConfigureAwait(false);
                var uri = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName(), data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SynapseArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>(Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a Sql pool's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource> Update(WaitUntil waitUntil, SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.Update");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName(), data, cancellationToken);
                var uri = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToSynapseVulnerabilityAssessmentPolicyBaselineName(), data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SynapseArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>(Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
